# Generated by Django 5.0.7 on 2024-08-03 19:55

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django.utils.timezone
import django_revision.revision_field
from django.conf import settings
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):
    replaces = [
        ("edc_auth", "0001_initial"),
        ("edc_auth", "0002_auto_20180803_0515"),
        ("edc_auth", "0003_auto_20180803_0532"),
        ("edc_auth", "0004_auto_20180804_2041"),
        ("edc_auth", "0005_userprofile_job_title"),
        ("edc_auth", "0006_userprofile_notifications"),
        ("edc_auth", "0007_auto_20181025_0150"),
        ("edc_auth", "0008_auto_20191022_0134"),
        ("edc_auth", "0009_userprofile_alternate_email"),
        ("edc_auth", "0010_auto_20191022_0422"),
        ("edc_auth", "0011_auto_20191025_2335"),
        ("edc_auth", "0012_auto_20191026_0034"),
        ("edc_auth", "0013_auto_20191026_0055"),
        ("edc_auth", "0014_auto_20191026_1841"),
        ("edc_auth", "0015_auto_20191026_2149"),
        ("edc_auth", "0016_auto_20191026_2153"),
        ("edc_auth", "0017_auto_20191026_2231"),
        ("edc_auth", "0018_auto_20191029_2039"),
        ("edc_auth", "0019_userprofile_export_format"),
        ("edc_auth", "0020_auto_20210120_0005"),
        ("edc_auth", "0021_auto_20210125_0421"),
        ("edc_auth", "0022_auto_20210125_2214"),
        ("edc_auth", "0023_auto_20210423_1451"),
        ("edc_auth", "0024_alter_userprofile_export_format"),
        ("edc_auth", "0025_permissions"),
        ("edc_auth", "0026_rename_permissions_edcpermissions"),
        ("edc_auth", "0027_alter_edcpermissions_options"),
        ("edc_auth", "0028_alter_role_options"),
        ("edc_auth", "0029_alter_edcpermissions_device_created_and_more"),
        ("edc_auth", "0030_alter_role_options_and_more"),
        ("edc_auth", "0031_alter_edcpermissions_options_and_more"),
        ("edc_auth", "0032_userprofile_is_multisite_viewer"),
        ("edc_auth", "0033_alter_userprofile_is_multisite_viewer"),
    ]

    initial = True

    dependencies = [
        ("auth", "0011_update_proxy_permissions"),
        ("edc_notification", "0002_update_notifications"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Role",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="(suggest 40 characters max.)",
                        max_length=250,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                (
                    "short_name",
                    models.CharField(
                        db_index=True,
                        help_text="This is the stored value, required",
                        max_length=250,
                        unique=True,
                        verbose_name="Stored value",
                    ),
                ),
                (
                    "display_index",
                    models.IntegerField(
                        db_index=True,
                        default=0,
                        help_text="Index to control display order if not alphabetical, not required",
                        verbose_name="display index",
                    ),
                ),
                (
                    "field_name",
                    models.CharField(
                        blank=True,
                        editable=False,
                        help_text="Not required",
                        max_length=25,
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.CharField(default="1.0", editable=False, max_length=35),
                ),
                ("groups", models.ManyToManyField(to="auth.group")),
            ],
            options={
                "ordering": ["display_index", "name"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="UserProfile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "clinic_label_printer",
                    models.CharField(
                        blank=True,
                        help_text='Change in <a href="/edc_label/">Edc Label Administration</a>',
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "lab_label_printer",
                    models.CharField(
                        blank=True,
                        help_text='Change in <a href="/edc_label/">Edc Label Administration</a>',
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "print_server",
                    models.CharField(
                        blank=True,
                        help_text='Change in <a href="/edc_label/">Edc Label Administration</a>',
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("sites", models.ManyToManyField(blank=True, to="sites.site")),
                ("job_title", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "email_notifications",
                    models.ManyToManyField(
                        blank=True,
                        limit_choices_to={"enabled": True},
                        related_name="email_notifications",
                        to="edc_notification.notification",
                    ),
                ),
                (
                    "mobile",
                    models.CharField(
                        blank=True,
                        help_text="e.g. +1234567890",
                        max_length=25,
                        null=True,
                        validators=[django.core.validators.RegexValidator(regex="^\\+\\d+")],
                    ),
                ),
                (
                    "sms_notifications",
                    models.ManyToManyField(
                        blank=True,
                        limit_choices_to={"enabled": True},
                        related_name="sms_notifications",
                        to="edc_notification.notification",
                    ),
                ),
                (
                    "alternate_email",
                    models.EmailField(
                        blank=True,
                        max_length=254,
                        null=True,
                        verbose_name="Alternate email address",
                    ),
                ),
                ("user_roles", models.ManyToManyField(to="edc_auth.role")),
            ],
        ),
        migrations.AddIndex(
            model_name="role",
            index=models.Index(
                fields=["id", "name", "display_index"], name="edc_auth_ro_id_587a9b_idx"
            ),
        ),
        migrations.RenameField(
            model_name="userprofile",
            old_name="user_roles",
            new_name="roles",
        ),
        migrations.AlterModelOptions(
            name="role",
            options={"ordering": ["display_index", "display_name"]},
        ),
        migrations.RemoveIndex(
            model_name="role",
            name="edc_auth_ro_id_587a9b_idx",
        ),
        migrations.RemoveField(
            model_name="role",
            name="field_name",
        ),
        migrations.RemoveField(
            model_name="role",
            name="version",
        ),
        migrations.RenameField(
            model_name="role",
            old_name="name",
            new_name="display_name",
        ),
        migrations.AddIndex(
            model_name="role",
            index=models.Index(
                fields=["id", "display_name", "display_index"],
                name="edc_auth_ro_id_cc6bf4_idx",
            ),
        ),
        migrations.RenameField(
            model_name="role",
            old_name="short_name",
            new_name="name",
        ),
        migrations.AlterField(
            model_name="role",
            name="display_name",
            field=models.CharField(
                db_index=True,
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Display Name",
            ),
        ),
        migrations.AlterField(
            model_name="role",
            name="name",
            field=models.CharField(
                db_index=True,
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="userprofile",
            name="roles",
            field=models.ManyToManyField(blank=True, to="edc_auth.role"),
        ),
        migrations.AlterField(
            model_name="userprofile",
            name="id",
            field=models.AutoField(primary_key=True, serialize=False),
        ),
        migrations.AddField(
            model_name="userprofile",
            name="export_format",
            field=models.CharField(
                blank=True,
                choices=[
                    ("CSV", "CSV (delimited by pipe `|`)"),
                    (114, "Stata v10 or later"),
                    (117, "Stata v13 or later"),
                    (118, "Stata v14 or later"),
                    (119, "Stata v15 or later"),
                ],
                default="CSV",
                help_text="Note: requires export permissions",
                max_length=25,
                null=True,
                verbose_name="Export format",
            ),
        ),
        migrations.AlterModelOptions(
            name="role",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "get_latest_by": "modified",
                "ordering": ["display_index", "display_name"],
            },
        ),
        migrations.CreateModel(
            name="EdcPermissions",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
            ],
            options={
                "abstract": False,
                "verbose_name": "Edc Permissions",
                "verbose_name_plural": "Edc Permissions",
            },
        ),
        migrations.AlterField(
            model_name="role",
            name="device_created",
            field=models.CharField(blank=True, max_length=10, verbose_name="Device created"),
        ),
        migrations.AlterField(
            model_name="role",
            name="device_modified",
            field=models.CharField(blank=True, max_length=10, verbose_name="Device modified"),
        ),
        migrations.AlterField(
            model_name="role",
            name="hostname_created",
            field=models.CharField(
                blank=True,
                default=_socket.gethostname,
                help_text="System field. (modified on create only)",
                max_length=60,
                verbose_name="Hostname created",
            ),
        ),
        migrations.AlterField(
            model_name="role",
            name="hostname_modified",
            field=django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                blank=True,
                help_text="System field. (modified on every save)",
                max_length=50,
                verbose_name="Hostname modified",
            ),
        ),
        migrations.AlterModelOptions(
            name="role",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
        ),
        migrations.RemoveIndex(
            model_name="role",
            name="edc_auth_ro_id_cc6bf4_idx",
        ),
        migrations.AddField(
            model_name="edcpermissions",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="edcpermissions",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="role",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="role",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddIndex(
            model_name="role",
            index=models.Index(
                fields=["display_name", "display_index"],
                name="edc_auth_ro_display_0b19e6_idx",
            ),
        ),
        migrations.AlterModelOptions(
            name="edcpermissions",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Edc Permissions",
                "verbose_name_plural": "Edc Permissions",
            },
        ),
        migrations.AlterModelOptions(
            name="userprofile",
            options={
                "verbose_name": "User profile",
                "verbose_name_plural": "User profiles",
            },
        ),
        migrations.AddIndex(
            model_name="edcpermissions",
            index=models.Index(
                fields=["modified", "created"], name="edc_auth_ed_modifie_cd58ed_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="edcpermissions",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_auth_ed_user_mo_817789_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="role",
            index=models.Index(
                fields=["modified", "created"], name="edc_auth_ro_modifie_fe8196_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="role",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_auth_ro_user_mo_dc165e_idx",
            ),
        ),
        migrations.AddField(
            model_name="userprofile",
            name="is_multisite_viewer",
            field=models.BooleanField(
                default=False,
                help_text="Designates if this user may view data from sites other than the current.",
                verbose_name="Multisite viewer",
            ),
        ),
    ]
