from django.conf import settings
from django.db import models
from django.utils.html import format_html
from django.utils.translation import gettext as _
from django_crypto_fields.fields import LastnameField
from django_crypto_fields.models import CryptoMixin

from edc_constants.choices import YES_NO

from ..validators import FullNameValidator, eligible_if_no


class VulnerabilityFieldsMixin(CryptoMixin, models.Model):
    is_incarcerated = models.CharField(
        verbose_name=_("Is the participant under involuntary incarceration?"),
        max_length=3,
        choices=YES_NO,
        validators=[eligible_if_no],
        null=True,
        help_text=_("If 'Yes' STOP participant cannot be consented."),
    )

    is_literate = models.CharField(
        verbose_name=_("Is the participant literate?"),
        max_length=3,
        choices=YES_NO,
        help_text=_(
            "If 'No' provide witness's name on this "
            "form and signature on the paper document."
        ),
    )

    witness_name = LastnameField(
        verbose_name=_("Witness's last and first name"),
        validators=[FullNameValidator()],
        blank=True,
        null=True,
        help_text=format_html(
            "{text1}.<BR>{text2}",
            text1="Required only if participant is illiterate",
            text2="Format is 'LASTNAME, FIRSTNAME'. All uppercase separated by a comma.",
        ),
    )

    language = models.CharField(
        verbose_name=_("Language of consent"),
        max_length=25,
        choices=settings.LANGUAGES,
        help_text=_(
            "The language used for the consent process will "
            "also be used during data collection."
        ),
    )

    class Meta:
        abstract = True
