# Generated by Django 4.2.7 on 2023-12-04 22:19

import uuid

from django.db import migrations, models

import edc_pharmacy.models.prescription
import edc_sites.models


class Migration(migrations.Migration):
    dependencies = [
        (
            "edc_pharmacy",
            "0020_alter_box_device_created_alter_box_device_modified_and_more",
        ),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="box",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Box",
                "verbose_name_plural": "Boxes",
            },
        ),
        migrations.AlterModelOptions(
            name="container",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Container",
                "verbose_name_plural": "Containers",
            },
        ),
        migrations.AlterModelOptions(
            name="containertype",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                )
            },
        ),
        migrations.AlterModelOptions(
            name="dispensinghistory",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Dispensing history",
                "verbose_name_plural": "Dispensing history",
            },
        ),
        migrations.AlterModelOptions(
            name="dosageguideline",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Dosage Guideline",
                "verbose_name_plural": "Dosage Guidelines",
            },
        ),
        migrations.AlterModelOptions(
            name="formulation",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Formulation",
                "verbose_name_plural": "Formulations",
            },
        ),
        migrations.AlterModelOptions(
            name="formulationtype",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "FormulationType",
                "verbose_name_plural": "FormulationTypes",
            },
        ),
        migrations.AlterModelOptions(
            name="frequencyunits",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Frequency units",
                "verbose_name_plural": "Frequency units",
            },
        ),
        migrations.AlterModelOptions(
            name="genericcontainer",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Item",
                "verbose_name_plural": "Items",
            },
        ),
        migrations.AlterModelOptions(
            name="labels",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Label",
                "verbose_name_plural": "Labels",
            },
        ),
        migrations.AlterModelOptions(
            name="location",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Location",
                "verbose_name_plural": "Locations",
            },
        ),
        migrations.AlterModelOptions(
            name="medication",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication",
                "verbose_name_plural": "Medications",
            },
        ),
        migrations.AlterModelOptions(
            name="medicationlot",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication lot",
                "verbose_name_plural": "Medication lots",
            },
        ),
        migrations.AlterModelOptions(
            name="order",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication order",
                "verbose_name_plural": "Medication orders",
            },
        ),
        migrations.AlterModelOptions(
            name="pillbottle",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Pill Bottle",
                "verbose_name_plural": "Pill Bottles",
            },
        ),
        migrations.AlterModelOptions(
            name="product",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication product",
                "verbose_name_plural": "Medication products",
            },
        ),
        migrations.AlterModelOptions(
            name="returnhistory",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Return history",
                "verbose_name_plural": "Return history",
            },
        ),
        migrations.AlterModelOptions(
            name="room",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Room",
                "verbose_name_plural": "Rooms",
            },
        ),
        migrations.AlterModelOptions(
            name="route",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Route",
                "verbose_name_plural": "Routes",
            },
        ),
        migrations.AlterModelOptions(
            name="rx",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Prescription",
                "verbose_name_plural": "Prescriptions",
            },
        ),
        migrations.AlterModelOptions(
            name="rxrefill",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "RX refill",
                "verbose_name_plural": "RX refills",
            },
        ),
        migrations.AlterModelOptions(
            name="shelf",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Shelf",
                "verbose_name_plural": "Shelves",
            },
        ),
        migrations.AlterModelOptions(
            name="stock",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication stock",
                "verbose_name_plural": "Medication stock",
            },
        ),
        migrations.AlterModelOptions(
            name="stockcreatelabels",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication stock: Create labels",
                "verbose_name_plural": "Medication stock: Create labels",
            },
        ),
        migrations.AlterModelOptions(
            name="stockreceiving",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Medication stock: Receiving",
                "verbose_name_plural": "Medication stock: Receiving",
            },
        ),
        migrations.AlterModelOptions(
            name="subjectpillbottle",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Subject Pill Bottle",
                "verbose_name_plural": "Subject Pill Bottles",
            },
        ),
        migrations.AlterModelOptions(
            name="units",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Units",
                "verbose_name_plural": "Units",
            },
        ),
        migrations.AlterModelOptions(
            name="unittype",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                )
            },
        ),
        migrations.AlterModelManagers(
            name="rx",
            managers=[
                ("objects", edc_pharmacy.models.prescription.rx.Manager()),
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.RemoveIndex(
            model_name="container",
            name="edc_pharmac_id_b68aba_idx",
        ),
        migrations.RemoveIndex(
            model_name="containertype",
            name="edc_pharmac_id_554046_idx",
        ),
        migrations.RemoveIndex(
            model_name="formulationtype",
            name="edc_pharmac_id_ff22c9_idx",
        ),
        migrations.RemoveIndex(
            model_name="frequencyunits",
            name="edc_pharmac_id_840f3f_idx",
        ),
        migrations.RemoveIndex(
            model_name="route",
            name="edc_pharmac_id_b35112_idx",
        ),
        migrations.RemoveIndex(
            model_name="units",
            name="edc_pharmac_id_93aa79_idx",
        ),
        migrations.RemoveIndex(
            model_name="unittype",
            name="edc_pharmac_id_8faa96_idx",
        ),
        migrations.AlterUniqueTogether(
            name="dispensinghistory",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="dosageguideline",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="formulation",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="medication",
            unique_together=set(),
        ),
        migrations.AddField(
            model_name="box",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="box",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="dispensinghistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="dispensinghistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="dosageguideline",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="dosageguideline",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="formulation",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="formulation",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="genericcontainer",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="genericcontainer",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaldispensinghistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaldispensinghistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicaldosageguideline",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicaldosageguideline",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalformulation",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalformulation",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicallabels",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicallabels",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalmedication",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalmedication",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalmedicationlot",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalmedicationlot",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalreturnhistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalreturnhistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalrx",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalrx",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalrxrefill",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalrxrefill",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockcreatelabels",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockcreatelabels",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockreceiving",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockreceiving",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="labels",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="labels",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="medication",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="medication",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="medicationlot",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="medicationlot",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="pillbottle",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="pillbottle",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="returnhistory",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="returnhistory",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="room",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="room",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="rx",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="rx",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="rxrefill",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="rxrefill",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="shelf",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="shelf",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="stockcreatelabels",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="stockcreatelabels",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="stockreceiving",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="stockreceiving",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="subjectpillbottle",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="subjectpillbottle",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AlterField(
            model_name="container",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="container",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="container",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="containertype",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="containertype",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="containertype",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="formulationtype",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="formulationtype",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="formulationtype",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="frequencyunits",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="frequencyunits",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="frequencyunits",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="historicalrx",
            name="rx_identifier",
            field=models.CharField(db_index=True, default=uuid.uuid4, max_length=36),
        ),
        migrations.AlterField(
            model_name="route",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="route",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="route",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="rx",
            name="rx_identifier",
            field=models.CharField(default=uuid.uuid4, max_length=36, unique=True),
        ),
        migrations.AlterField(
            model_name="units",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="units",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="units",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="unittype",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AlterField(
            model_name="unittype",
            name="display_name",
            field=models.CharField(
                help_text="(suggest 40 characters max.)",
                max_length=250,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AlterField(
            model_name="unittype",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AddIndex(
            model_name="box",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_1b5950_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="box",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_d39cd1_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="container",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_0172ab_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="containertype",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_54ef1a_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dispensinghistory",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_fb4eea_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dispensinghistory",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_a6dfb9_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="dosageguideline",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_19a9bf_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dosageguideline",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_8fded1_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="formulation",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_b09151_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="formulation",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_c3278d_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="formulationtype",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_ae9253_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="frequencyunits",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_74a9fb_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="genericcontainer",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_8a380a_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="genericcontainer",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_985106_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="labels",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_a6e280_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="labels",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_bd2b4f_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="location",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_c4a1aa_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="location",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_1838af_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="medication",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_9ca5c6_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="medication",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_471fe8_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="medicationlot",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_ac85b9_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="medicationlot",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_c69b56_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="order",
            index=models.Index(
                fields=["subject_identifier"], name="edc_pharmac_subject_36f4ea_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="order",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_dd4593_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="order",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_c19a6f_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="pillbottle",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_480869_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="pillbottle",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_71fb9d_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="product",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_f3e4c4_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="product",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_3e12e8_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="returnhistory",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_698780_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="returnhistory",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_c6202e_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="room",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_1f05db_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="room",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_687474_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="route",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_7e4edc_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="rx",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_986021_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="rx",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_b9ac53_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="rxrefill",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_07388c_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="rxrefill",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_451240_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="shelf",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_b28e36_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="shelf",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_392c48_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stock",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_9836a2_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stock",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_be4ea3_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stockcreatelabels",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_3dc094_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stockcreatelabels",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_434ace_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stockreceiving",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_b91a43_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stockreceiving",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_74be33_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="subjectpillbottle",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_c94c44_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="subjectpillbottle",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_230575_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="units",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_f1b67e_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="unittype",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_60c19d_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="dispensinghistory",
            constraint=models.UniqueConstraint(
                fields=("rx_refill", "dispensed_datetime"),
                name="edc_pharmacy_dispensinghistory_rx_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="dosageguideline",
            constraint=models.UniqueConstraint(
                fields=("medication", "dose", "dose_units", "dose_per_kg"),
                name="edc_pharmacy_dosageguideline_med_dose_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="formulation",
            constraint=models.UniqueConstraint(
                fields=("medication", "strength", "units", "formulation_type"),
                name="edc_pharmacy_formulation_med_stren_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="medication",
            constraint=models.UniqueConstraint(
                fields=("name", "display_name"),
                name="edc_pharmacy_medication_name_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="returnhistory",
            constraint=models.UniqueConstraint(
                fields=("rx_refill", "return_datetime"),
                name="edc_pharmacy_returnhistory_rx_uniq",
            ),
        ),
    ]
