# Generated by Django 5.1.2 on 2024-11-14 20:58

import uuid
from decimal import Decimal

import _socket
import django.contrib.sites.models
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_crypto_fields.fields.encrypted_char_field
import django_revision.revision_field
import simple_history.models
from django.conf import settings
from django.db import migrations, models

import edc_pharmacy.models.medication.assignment
import edc_pharmacy.models.medication.medication
import edc_pharmacy.models.stock.allocation
import edc_pharmacy.models.stock.container
import edc_pharmacy.models.stock.dispense
import edc_pharmacy.models.stock.lot
import edc_pharmacy.models.stock.managers
import edc_pharmacy.models.stock.order
import edc_pharmacy.models.stock.order_item
import edc_pharmacy.models.stock.product
import edc_pharmacy.models.stock.receive
import edc_pharmacy.models.stock.receive_item
import edc_pharmacy.models.stock.repack_request
import edc_pharmacy.models.stock.stock_request
import edc_pharmacy.models.stock.stock_request_item
import edc_pharmacy.models.stock.stock_transfer
import edc_pharmacy.models.stock.stock_transfer_item
import edc_pharmacy.models.stock.supplier
import django.utils.timezone


class Migration(migrations.Migration):
    dependencies = [
        ("edc_pharmacy", "0023_remove_rx_edc_pharmac_modifie_986021_idx_and_more"),
        ("edc_registration", "0031_alter_historicalregisteredsubject_site_and_more"),
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Allocation",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "allocation_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "allocation_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "allocated_by",
                    models.CharField(blank=True, max_length=50, null=True),
                ),
            ],
            options={
                "verbose_name": "Allocation",
                "verbose_name_plural": "Allocations",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.allocation.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Assignment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="word as in randomization list (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "display_label",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="If not provided, defaults to 'assignment' (Encryption: RSA local)",
                        max_length=71,
                        null=True,
                        verbose_name="Formal label",
                    ),
                ),
            ],
            options={
                "verbose_name": "Assignment",
                "verbose_name_plural": "Assignments",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.medication.assignment.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="ContainerUnits",
            fields=[
                (
                    "name",
                    models.CharField(
                        help_text="This is the stored value, required",
                        max_length=250,
                        unique=True,
                        verbose_name="Stored value",
                    ),
                ),
                (
                    "plural_name",
                    models.CharField(max_length=250, null=True, verbose_name="Plural name"),
                ),
                (
                    "display_index",
                    models.IntegerField(
                        default=0,
                        help_text="Index to control display order if not alphabetical, not required",
                        verbose_name="display index",
                    ),
                ),
                (
                    "field_name",
                    models.CharField(
                        blank=True,
                        editable=False,
                        help_text="Not required",
                        max_length=25,
                        null=True,
                    ),
                ),
                ("extra_value", models.CharField(max_length=250, null=True)),
                (
                    "version",
                    models.CharField(default="1.0", editable=False, max_length=35),
                ),
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "display_name",
                    models.CharField(
                        blank=True,
                        help_text="(suggest 40 characters max.)",
                        max_length=250,
                        null=True,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
            ],
            options={
                "verbose_name": "Container units",
                "verbose_name_plural": "Container units",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
            },
        ),
        migrations.CreateModel(
            name="Dispense",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "dispense_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "dispense_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("to_clinician", models.BooleanField(default=False)),
                ("to_clinician_datetime", models.DateTimeField(blank=True, null=True)),
                ("to_subject", models.BooleanField(default=False)),
                ("to_subject_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "crf_label_lower",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "crf_field_name",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("crf_id", models.UUIDField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Dispense",
                "verbose_name_plural": "Dispense",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.dispense.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="EdcPermissions",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
            ],
            options={
                "verbose_name": "Edc Permissions",
                "verbose_name_plural": "Edc Permissions",
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="HistoricalAllocation",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "allocation_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "allocation_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "allocated_by",
                    models.CharField(blank=True, max_length=50, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Allocation",
                "verbose_name_plural": "historical Allocations",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAssignment",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "name",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="word as in randomization list (Encryption: RSA local)",
                        max_length=71,
                    ),
                ),
                (
                    "display_label",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="If not provided, defaults to 'assignment' (Encryption: RSA local)",
                        max_length=71,
                        null=True,
                        verbose_name="Formal label",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Assignment",
                "verbose_name_plural": "historical Assignments",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalContainer",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("name", models.CharField(blank=True, db_index=True, max_length=50)),
                (
                    "qty",
                    models.DecimalField(decimal_places=2, max_digits=10, null=True),
                ),
                ("qty_decimal_places", models.IntegerField(default=0)),
                (
                    "may_order_as",
                    models.BooleanField(
                        default=False, verbose_name="Container may be used for ordering"
                    ),
                ),
                (
                    "may_receive_as",
                    models.BooleanField(
                        default=False,
                        verbose_name="Container may be used for receiving",
                    ),
                ),
                (
                    "may_repack_as",
                    models.BooleanField(
                        default=False,
                        verbose_name="Container may be used for repack request",
                    ),
                ),
                (
                    "may_request_as",
                    models.BooleanField(
                        default=False,
                        verbose_name="Container may be used for stock request",
                    ),
                ),
                (
                    "may_dispense_as",
                    models.BooleanField(
                        default=False,
                        verbose_name="Container may be used for dispensing to subject",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Container",
                "verbose_name_plural": "historical Containers",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDispense",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "dispense_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "dispense_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("to_clinician", models.BooleanField(default=False)),
                ("to_clinician_datetime", models.DateTimeField(blank=True, null=True)),
                ("to_subject", models.BooleanField(default=False)),
                ("to_subject_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "crf_label_lower",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                (
                    "crf_field_name",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("crf_id", models.UUIDField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Dispense",
                "verbose_name_plural": "historical Dispense",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalLot",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "lot_identifier",
                    models.CharField(
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=25,
                        null=True,
                    ),
                ),
                ("lot_no", models.CharField(db_index=True, max_length=50)),
                ("expiration_date", models.DateField()),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Lot",
                "verbose_name_plural": "historical Lots",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalOrderItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "order_item_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "qty",
                    models.DecimalField(decimal_places=2, max_digits=20, null=True),
                ),
                (
                    "unit_qty",
                    models.DecimalField(decimal_places=2, max_digits=20, null=True),
                ),
                (
                    "unit_qty_received",
                    models.DecimalField(decimal_places=2, max_digits=20, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("partial", "Partial"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="New",
                        help_text="Updates in the signal",
                        max_length=25,
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Order item",
                "verbose_name_plural": "historical Order items",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalReceive",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "receive_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "receive_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "item_count",
                    models.IntegerField(null=True, verbose_name="Item count"),
                ),
                ("comment", models.TextField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Receive",
                "verbose_name_plural": "historical Receive",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalReceiveItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "receive_item_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "receive_item_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="Leave blank to use default",
                        max_length=200,
                        null=True,
                    ),
                ),
                (
                    "qty",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=20,
                        null=True,
                        verbose_name="Quantity",
                    ),
                ),
                (
                    "unit_qty",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Quantity x Container.Quantity, e.g. 10 x Bottle of 128 = 1280",
                        max_digits=20,
                        null=True,
                        verbose_name="Unit quantity",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Receive item",
                "verbose_name_plural": "historical Receive items",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalRepackRequest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "repack_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "repack_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "qty",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=20,
                        null=True,
                        verbose_name="Quantity",
                    ),
                ),
                ("processed", models.BooleanField(default=False)),
                ("stock_count", models.IntegerField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Repack request",
                "verbose_name_plural": "historical Repack request",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalStockRequest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "request_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "request_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "containers_per_subject",
                    models.PositiveSmallIntegerField(
                        default=1, verbose_name="Number of containers per subject"
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        default=0,
                        help_text="Matches the number of Request items.",
                        verbose_name="Item count",
                    ),
                ),
                (
                    "subject_identifiers",
                    models.TextField(
                        blank=True,
                        help_text="By adding subject identifiers in this box, only these subjects will be included in the request. All others will be ignored.",
                        null=True,
                        verbose_name="Include ONLY these subjects in this request. (Usually left blank)",
                    ),
                ),
                (
                    "excluded_subject_identifiers",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Exclude these subjects from this request. (Usually left blank)",
                    ),
                ),
                (
                    "labels",
                    models.TextField(
                        blank=True,
                        help_text="A cell to capture and confirm printed/scanned labels related to this Stock request. See StockRequestItem.",
                        null=True,
                        verbose_name="Labels",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("open", "Open"), ("closed", "Closed")],
                        default="open",
                        max_length=25,
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Stock request",
                "verbose_name_plural": "historical Stock requests",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalStockRequestItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "request_item_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "request_item_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("appt_datetime", models.DateTimeField(blank=True, null=True)),
                ("in_stock", models.BooleanField(default=False)),
                (
                    "received",
                    models.BooleanField(default=False, help_text="Received at site"),
                ),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Stock request item",
                "verbose_name_plural": "historical Stock request items",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalStockTransfer",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "transfer_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "transfer_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("item_count", models.PositiveIntegerField(null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Stock transfer",
                "verbose_name_plural": "historical Stock transfers",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalStockTransferItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "transfer_item_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                    ),
                ),
                (
                    "transfer_item_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Stock transfer item",
                "verbose_name_plural": "historical Stock transfer items",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSupplier",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "address_one",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "address_two",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("city", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "postal_code",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("state", models.CharField(blank=True, max_length=255, null=True)),
                ("country", models.CharField(blank=True, max_length=255, null=True)),
                ("email", models.EmailField(blank=True, max_length=254, null=True)),
                (
                    "email_alternative",
                    models.EmailField(blank=True, max_length=254, null=True),
                ),
                ("telephone", models.CharField(blank=True, max_length=15, null=True)),
                (
                    "telephone_alternative",
                    models.CharField(blank=True, max_length=15, null=True),
                ),
                (
                    "supplier_identifier",
                    models.CharField(blank=True, db_index=True, max_length=36, null=True),
                ),
                ("name", models.CharField(db_index=True, max_length=255)),
                ("contact", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "supplier_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Supplier",
                "verbose_name_plural": "historical Suppliers",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="Lot",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "lot_identifier",
                    models.CharField(
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=25,
                        null=True,
                        unique=True,
                    ),
                ),
                ("lot_no", models.CharField(max_length=50, unique=True)),
                ("expiration_date", models.DateField()),
            ],
            options={
                "verbose_name": "Lot",
                "verbose_name_plural": "Lots",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.lot.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="OrderItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "order_item_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "qty",
                    models.DecimalField(decimal_places=2, max_digits=20, null=True),
                ),
                (
                    "unit_qty",
                    models.DecimalField(decimal_places=2, max_digits=20, null=True),
                ),
                (
                    "unit_qty_received",
                    models.DecimalField(decimal_places=2, max_digits=20, null=True),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("partial", "Partial"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="New",
                        help_text="Updates in the signal",
                        max_length=25,
                    ),
                ),
            ],
            options={
                "verbose_name": "Order item",
                "verbose_name_plural": "Order items",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.order_item.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Receive",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "receive_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "receive_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "item_count",
                    models.IntegerField(null=True, verbose_name="Item count"),
                ),
                ("comment", models.TextField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Receive",
                "verbose_name_plural": "Receive",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.receive.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="ReceiveItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "receive_item_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "receive_item_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        help_text="Leave blank to use default",
                        max_length=200,
                        null=True,
                    ),
                ),
                (
                    "qty",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=20,
                        null=True,
                        verbose_name="Quantity",
                    ),
                ),
                (
                    "unit_qty",
                    models.DecimalField(
                        blank=True,
                        decimal_places=2,
                        help_text="Quantity x Container.Quantity, e.g. 10 x Bottle of 128 = 1280",
                        max_digits=20,
                        null=True,
                        verbose_name="Unit quantity",
                    ),
                ),
            ],
            options={
                "verbose_name": "Receive item",
                "verbose_name_plural": "Receive items",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.receive_item.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="RepackRequest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "repack_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "repack_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "qty",
                    models.DecimalField(
                        decimal_places=2,
                        max_digits=20,
                        null=True,
                        verbose_name="Quantity",
                    ),
                ),
                ("processed", models.BooleanField(default=False)),
                ("stock_count", models.IntegerField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Repack request",
                "verbose_name_plural": "Repack request",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.repack_request.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="StockRequest",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "request_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "request_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "containers_per_subject",
                    models.PositiveSmallIntegerField(
                        default=1, verbose_name="Number of containers per subject"
                    ),
                ),
                (
                    "item_count",
                    models.IntegerField(
                        default=0,
                        help_text="Matches the number of Request items.",
                        verbose_name="Item count",
                    ),
                ),
                (
                    "subject_identifiers",
                    models.TextField(
                        blank=True,
                        help_text="By adding subject identifiers in this box, only these subjects will be included in the request. All others will be ignored.",
                        null=True,
                        verbose_name="Include ONLY these subjects in this request. (Usually left blank)",
                    ),
                ),
                (
                    "excluded_subject_identifiers",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Exclude these subjects from this request. (Usually left blank)",
                    ),
                ),
                (
                    "labels",
                    models.TextField(
                        blank=True,
                        help_text="A cell to capture and confirm printed/scanned labels related to this Stock request. See StockRequestItem.",
                        null=True,
                        verbose_name="Labels",
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[("open", "Open"), ("closed", "Closed")],
                        default="open",
                        max_length=25,
                    ),
                ),
            ],
            options={
                "verbose_name": "Stock request",
                "verbose_name_plural": "Stock requests",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.stock_request.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="StockRequestItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "visit_code",
                    models.CharField(editable=False, max_length=25, null=True),
                ),
                (
                    "visit_code_sequence",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="An integer to represent the sequence of additional appointments relative to the base appointment, 0, needed to complete data collection for the timepoint. (NNNN.0)",
                        null=True,
                        verbose_name="Sequence",
                    ),
                ),
                (
                    "request_item_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "request_item_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("appt_datetime", models.DateTimeField(blank=True, null=True)),
                ("in_stock", models.BooleanField(default=False)),
                (
                    "received",
                    models.BooleanField(default=False, help_text="Received at site"),
                ),
                ("received_datetime", models.DateTimeField(blank=True, null=True)),
            ],
            options={
                "verbose_name": "Stock request item",
                "verbose_name_plural": "Stock request items",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.stock_request_item.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="StockTransfer",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "transfer_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "transfer_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("item_count", models.PositiveIntegerField(null=True)),
            ],
            options={
                "verbose_name": "Stock transfer",
                "verbose_name_plural": "Stock transfers",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.stock_transfer.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="StockTransferItem",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "transfer_item_identifier",
                    models.CharField(
                        blank=True,
                        help_text="A sequential unique identifier set by the EDC",
                        max_length=36,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "transfer_item_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
            ],
            options={
                "verbose_name": "Stock transfer item",
                "verbose_name_plural": "Stock transfer items",
                "abstract": False,
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "default_manager_name": "objects",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.stock_transfer_item.Manager()),
            ],
        ),
        migrations.CreateModel(
            name="Supplier",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django.utils.timezone.now,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                        verbose_name="Hostname created",
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                        verbose_name="Hostname modified",
                    ),
                ),
                (
                    "device_created",
                    models.CharField(blank=True, max_length=10, verbose_name="Device created"),
                ),
                (
                    "device_modified",
                    models.CharField(
                        blank=True, max_length=10, verbose_name="Device modified"
                    ),
                ),
                (
                    "locale_created",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale created",
                    ),
                ),
                (
                    "locale_modified",
                    models.CharField(
                        blank=True,
                        help_text="Auto-updated by Modeladmin",
                        max_length=10,
                        null=True,
                        verbose_name="Locale modified",
                    ),
                ),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "address_one",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "address_two",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("city", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "postal_code",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("state", models.CharField(blank=True, max_length=255, null=True)),
                ("country", models.CharField(blank=True, max_length=255, null=True)),
                ("email", models.EmailField(blank=True, max_length=254, null=True)),
                (
                    "email_alternative",
                    models.EmailField(blank=True, max_length=254, null=True),
                ),
                ("telephone", models.CharField(blank=True, max_length=15, null=True)),
                (
                    "telephone_alternative",
                    models.CharField(blank=True, max_length=15, null=True),
                ),
                (
                    "supplier_identifier",
                    models.CharField(blank=True, max_length=36, null=True, unique=True),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("contact", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "supplier_datetime",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
            ],
            options={
                "verbose_name": "Supplier",
                "verbose_name_plural": "Suppliers",
            },
            managers=[
                ("objects", edc_pharmacy.models.stock.supplier.Manager()),
            ],
        ),
        migrations.RemoveField(
            model_name="genericcontainer",
            name="box",
        ),
        migrations.RemoveField(
            model_name="genericcontainer",
            name="container_type",
        ),
        migrations.RemoveField(
            model_name="historicallabels",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicallabels",
            name="stock_create_labels",
        ),
        migrations.RemoveField(
            model_name="historicalmedicationlot",
            name="formulation",
        ),
        migrations.RemoveField(
            model_name="historicalmedicationlot",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalstockcreatelabels",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalstockcreatelabels",
            name="product",
        ),
        migrations.RemoveField(
            model_name="historicalstockreceiving",
            name="history_user",
        ),
        migrations.RemoveField(
            model_name="historicalstockreceiving",
            name="product",
        ),
        migrations.RemoveField(
            model_name="labels",
            name="stock_create_labels",
        ),
        migrations.RemoveField(
            model_name="medicationlot",
            name="formulation",
        ),
        migrations.RemoveField(
            model_name="subjectpillbottle",
            name="medication_lot",
        ),
        migrations.RemoveField(
            model_name="product",
            name="medication_lot",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="medication_lot",
        ),
        migrations.RemoveField(
            model_name="pillbottle",
            name="medication_lot",
        ),
        migrations.RemoveField(
            model_name="pillbottle",
            name="box",
        ),
        migrations.RemoveField(
            model_name="pillbottle",
            name="container_type",
        ),
        migrations.RemoveField(
            model_name="pillbottle",
            name="formulation",
        ),
        migrations.RemoveField(
            model_name="pillbottle",
            name="source_container",
        ),
        migrations.RemoveField(
            model_name="subjectpillbottle",
            name="source_container",
        ),
        migrations.RemoveField(
            model_name="stockcreatelabels",
            name="product",
        ),
        migrations.RemoveField(
            model_name="stockreceiving",
            name="product",
        ),
        migrations.RemoveField(
            model_name="subjectpillbottle",
            name="box",
        ),
        migrations.RemoveField(
            model_name="subjectpillbottle",
            name="container_type",
        ),
        migrations.RemoveField(
            model_name="subjectpillbottle",
            name="formulation",
        ),
        migrations.DeleteModel(
            name="Subject",
        ),
        migrations.CreateModel(
            name="SiteProxy",
            fields=[],
            options={
                "verbose_name": "Site",
                "verbose_name_plural": "Sites",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("sites.site",),
            managers=[
                ("objects", django.contrib.sites.models.SiteManager()),
            ],
        ),
        migrations.AlterModelOptions(
            name="container",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Container",
                "verbose_name_plural": "Containers",
            },
        ),
        migrations.AlterModelOptions(
            name="containertype",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Container type",
                "verbose_name_plural": "Container types",
            },
        ),
        migrations.AlterModelOptions(
            name="formulationtype",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Formulation type",
                "verbose_name_plural": "Formulation types",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalorder",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Order",
                "verbose_name_plural": "historical Orders",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalproduct",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Product",
                "verbose_name_plural": "historical Product",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalrxrefill",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Prescription: Refill",
                "verbose_name_plural": "historical Prescription: Refills",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalstock",
            options={
                "get_latest_by": ("history_date", "history_id"),
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Stock",
                "verbose_name_plural": "historical Stock",
            },
        ),
        migrations.AlterModelOptions(
            name="order",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Order",
                "verbose_name_plural": "Orders",
            },
        ),
        migrations.AlterModelOptions(
            name="product",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Product",
                "verbose_name_plural": "Product",
            },
        ),
        migrations.AlterModelOptions(
            name="rxrefill",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Prescription: Refill",
                "verbose_name_plural": "Prescription: Refills",
            },
        ),
        migrations.AlterModelOptions(
            name="stock",
            options={
                "default_manager_name": "objects",
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "verbose_name": "Stock",
                "verbose_name_plural": "Stock",
            },
        ),
        migrations.AlterModelManagers(
            name="container",
            managers=[
                ("objects", edc_pharmacy.models.stock.container.Manager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="medication",
            managers=[
                ("objects", edc_pharmacy.models.medication.medication.Manager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="order",
            managers=[
                ("objects", edc_pharmacy.models.stock.order.Manager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="product",
            managers=[
                ("objects", edc_pharmacy.models.stock.product.Manager()),
            ],
        ),
        migrations.AlterModelManagers(
            name="stock",
            managers=[
                ("objects", edc_pharmacy.models.stock.managers.StockManager()),
            ],
        ),
        migrations.RemoveIndex(
            model_name="container",
            name="edc_pharmac_display_0172ab_idx",
        ),
        migrations.RemoveIndex(
            model_name="location",
            name="edc_pharmac_modifie_c4a1aa_idx",
        ),
        migrations.RemoveIndex(
            model_name="location",
            name="edc_pharmac_user_mo_1838af_idx",
        ),
        migrations.RemoveIndex(
            model_name="order",
            name="edc_pharmac_subject_36f4ea_idx",
        ),
        migrations.RemoveField(
            model_name="container",
            name="display_index",
        ),
        migrations.RemoveField(
            model_name="container",
            name="display_name",
        ),
        migrations.RemoveField(
            model_name="container",
            name="extra_value",
        ),
        migrations.RemoveField(
            model_name="container",
            name="field_name",
        ),
        migrations.RemoveField(
            model_name="container",
            name="plural_name",
        ),
        migrations.RemoveField(
            model_name="container",
            name="version",
        ),
        migrations.RemoveField(
            model_name="historicalorder",
            name="product",
        ),
        migrations.RemoveField(
            model_name="historicalorder",
            name="qty_ordered",
        ),
        migrations.RemoveField(
            model_name="historicalorder",
            name="qty_supplied",
        ),
        migrations.RemoveField(
            model_name="historicalorder",
            name="subject_identifier",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="container",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="count_per_container",
        ),
        migrations.RemoveField(
            model_name="historicalproduct",
            name="site",
        ),
        migrations.RemoveField(
            model_name="historicalstock",
            name="site",
        ),
        migrations.RemoveField(
            model_name="location",
            name="description",
        ),
        migrations.RemoveField(
            model_name="location",
            name="location_datetime",
        ),
        migrations.RemoveField(
            model_name="location",
            name="location_identifier",
        ),
        migrations.RemoveField(
            model_name="order",
            name="product",
        ),
        migrations.RemoveField(
            model_name="order",
            name="qty_ordered",
        ),
        migrations.RemoveField(
            model_name="order",
            name="qty_supplied",
        ),
        migrations.RemoveField(
            model_name="order",
            name="subject_identifier",
        ),
        migrations.RemoveField(
            model_name="product",
            name="container",
        ),
        migrations.RemoveField(
            model_name="product",
            name="count_per_container",
        ),
        migrations.RemoveField(
            model_name="product",
            name="site",
        ),
        migrations.RemoveField(
            model_name="stock",
            name="site",
        ),
        migrations.AddField(
            model_name="container",
            name="container_type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.containertype",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="created",
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name="container",
            name="device_created",
            field=models.CharField(blank=True, max_length=10, verbose_name="Device created"),
        ),
        migrations.AddField(
            model_name="container",
            name="device_modified",
            field=models.CharField(blank=True, max_length=10, verbose_name="Device modified"),
        ),
        migrations.AddField(
            model_name="container",
            name="hostname_created",
            field=models.CharField(
                blank=True,
                default=_socket.gethostname,
                help_text="System field. (modified on create only)",
                max_length=60,
                verbose_name="Hostname created",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="hostname_modified",
            field=django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                blank=True,
                help_text="System field. (modified on every save)",
                max_length=50,
                verbose_name="Hostname modified",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="locale_created",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale created",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="locale_modified",
            field=models.CharField(
                blank=True,
                help_text="Auto-updated by Modeladmin",
                max_length=10,
                null=True,
                verbose_name="Locale modified",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="may_dispense_as",
            field=models.BooleanField(
                default=False,
                verbose_name="Container may be used for dispensing to subject",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="may_order_as",
            field=models.BooleanField(
                default=False, verbose_name="Container may be used for ordering"
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="may_receive_as",
            field=models.BooleanField(
                default=False, verbose_name="Container may be used for receiving"
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="may_repack_as",
            field=models.BooleanField(
                default=False, verbose_name="Container may be used for repack request"
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="may_request_as",
            field=models.BooleanField(
                default=False, verbose_name="Container may be used for stock request"
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="modified",
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name="container",
            name="qty",
            field=models.DecimalField(decimal_places=2, max_digits=10, null=True),
        ),
        migrations.AddField(
            model_name="container",
            name="qty_decimal_places",
            field=models.IntegerField(default=0),
        ),
        migrations.AddField(
            model_name="container",
            name="revision",
            field=django_revision.revision_field.RevisionField(
                blank=True,
                editable=False,
                help_text="System field. Git repository tag:branch:commit.",
                max_length=75,
                null=True,
                verbose_name="Revision",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="user_created",
            field=django_audit_fields.fields.userfield.UserField(
                blank=True,
                help_text="Updated by admin.save_model",
                max_length=50,
                verbose_name="user created",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="user_modified",
            field=django_audit_fields.fields.userfield.UserField(
                blank=True,
                help_text="Updated by admin.save_model",
                max_length=50,
                verbose_name="user modified",
            ),
        ),
        migrations.AddField(
            model_name="formulation",
            name="description",
            field=models.CharField(blank=True, max_length=250, null=True),
        ),
        migrations.AddField(
            model_name="historicalformulation",
            name="description",
            field=models.CharField(blank=True, max_length=250, null=True),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="comment",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="item_count",
            field=models.IntegerField(null=True, verbose_name="Item count"),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="order_identifier",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="A sequential unique identifier set by the EDC",
                max_length=36,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="sent",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="status",
            field=models.CharField(
                choices=[
                    ("New", "New"),
                    ("partial", "Partial"),
                    ("COMPLETE", "Complete"),
                ],
                default="New",
                help_text="Updates in the signal",
                max_length=25,
            ),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="title",
            field=models.CharField(
                help_text="A short description of this order", max_length=50, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="allocated_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="at_location",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="code",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="A unique alphanumeric code",
                max_length=15,
                null=True,
                verbose_name="Stock code",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="confirmed",
            field=models.BooleanField(
                default=False,
                help_text="True if stock was labelled and confirmed; False if stock was received/repacked but never confirmed.",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="confirmed_by",
            field=models.CharField(
                blank=True, help_text="label_lower", max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="confirmed_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="container",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="description",
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="from_stock",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.stock",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="qty",
            field=models.DecimalField(
                decimal_places=2, default=Decimal("0"), max_digits=20, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="qty_in",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1),
                ],
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="qty_out",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1),
                ],
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="status",
            field=models.CharField(
                choices=[
                    ("available", "Available"),
                    ("allocated", "Allocated"),
                    ("zero_item", "Zero"),
                ],
                default="available",
                max_length=25,
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="stock_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now, help_text="date stock record created"
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="subject_identifier",
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="unit_qty_in",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="unit_qty_out",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="display_index",
            field=models.IntegerField(
                default=0,
                help_text="Index to control display order if not alphabetical, not required",
                verbose_name="display index",
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="display_name",
            field=models.CharField(
                blank=True,
                help_text="(suggest 40 characters max.)",
                max_length=250,
                null=True,
                unique=True,
                verbose_name="Name",
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="extra_value",
            field=models.CharField(max_length=250, null=True),
        ),
        migrations.AddField(
            model_name="location",
            name="field_name",
            field=models.CharField(
                blank=True,
                editable=False,
                help_text="Not required",
                max_length=25,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="plural_name",
            field=models.CharField(max_length=250, null=True, verbose_name="Plural name"),
        ),
        migrations.AddField(
            model_name="location",
            name="site",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="sites.site",
            ),
        ),
        migrations.AddField(
            model_name="location",
            name="version",
            field=models.CharField(default="1.0", editable=False, max_length=35),
        ),
        migrations.AddField(
            model_name="order",
            name="comment",
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="order",
            name="item_count",
            field=models.IntegerField(null=True, verbose_name="Item count"),
        ),
        migrations.AddField(
            model_name="order",
            name="order_identifier",
            field=models.CharField(
                blank=True,
                help_text="A sequential unique identifier set by the EDC",
                max_length=36,
                null=True,
                unique=True,
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="sent",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="order",
            name="status",
            field=models.CharField(
                choices=[
                    ("New", "New"),
                    ("partial", "Partial"),
                    ("COMPLETE", "Complete"),
                ],
                default="New",
                help_text="Updates in the signal",
                max_length=25,
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="title",
            field=models.CharField(
                help_text="A short description of this order", max_length=50, null=True
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="allocated_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="stock",
            name="at_location",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="stock",
            name="code",
            field=models.CharField(
                blank=True,
                help_text="A unique alphanumeric code",
                max_length=15,
                null=True,
                unique=True,
                verbose_name="Stock code",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="confirmed",
            field=models.BooleanField(
                default=False,
                help_text="True if stock was labelled and confirmed; False if stock was received/repacked but never confirmed.",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="confirmed_by",
            field=models.CharField(
                blank=True, help_text="label_lower", max_length=150, null=True
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="confirmed_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="stock",
            name="container",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="description",
            field=models.CharField(blank=True, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name="stock",
            name="from_stock",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="source_stock",
                to="edc_pharmacy.stock",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="qty",
            field=models.DecimalField(
                decimal_places=2, default=Decimal("0"), max_digits=20, null=True
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="qty_in",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1),
                ],
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="qty_out",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1),
                ],
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="status",
            field=models.CharField(
                choices=[
                    ("available", "Available"),
                    ("allocated", "Allocated"),
                    ("zero_item", "Zero"),
                ],
                default="available",
                max_length=25,
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="stock_datetime",
            field=models.DateTimeField(
                default=django.utils.timezone.now, help_text="date stock record created"
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="subject_identifier",
            field=models.CharField(blank=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name="stock",
            name="unit_qty_in",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="unit_qty_out",
            field=models.DecimalField(
                decimal_places=2,
                default=Decimal("0"),
                max_digits=20,
                validators=[django.core.validators.MinValueValidator(0)],
            ),
        ),
        migrations.AlterField(
            model_name="container",
            name="id",
            field=django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                blank=True,
                editable=False,
                help_text="System auto field. UUID primary key.",
                primary_key=True,
                serialize=False,
            ),
        ),
        migrations.AlterField(
            model_name="container",
            name="name",
            field=models.CharField(blank=True, max_length=50, unique=True),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="name",
            field=models.CharField(
                blank=True, help_text="Leave blank to use default", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalproduct",
            name="product_identifier",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="A sequential unique identifier set by the EDC",
                max_length=36,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="historicalrx",
            name="registered_subject",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_registration.registeredsubject",
                verbose_name="Subject Identifier",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstock",
            name="stock_identifier",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="A sequential unique identifier set by the EDC",
                max_length=36,
                null=True,
                verbose_name="Internal stock identifier",
            ),
        ),
        migrations.AlterField(
            model_name="location",
            name="id",
            field=models.AutoField(primary_key=True, serialize=False),
        ),
        migrations.AlterField(
            model_name="location",
            name="name",
            field=models.CharField(
                help_text="This is the stored value, required",
                max_length=250,
                unique=True,
                verbose_name="Stored value",
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="name",
            field=models.CharField(
                blank=True, help_text="Leave blank to use default", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="product",
            name="product_identifier",
            field=models.CharField(
                blank=True,
                help_text="A sequential unique identifier set by the EDC",
                max_length=36,
                null=True,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="rx",
            name="registered_subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_registration.registeredsubject",
                verbose_name="Subject Identifier",
            ),
        ),
        migrations.AlterField(
            model_name="stock",
            name="stock_identifier",
            field=models.CharField(
                blank=True,
                help_text="A sequential unique identifier set by the EDC",
                max_length=36,
                null=True,
                unique=True,
                verbose_name="Internal stock identifier",
            ),
        ),
        migrations.AddIndex(
            model_name="location",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_c5b56a_idx",
            ),
        ),
        migrations.AddField(
            model_name="allocation",
            name="registered_subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_registration.registeredsubject",
                verbose_name="Allocated to",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="allocation",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Subject allocation",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.allocation",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="allocation",
            field=models.OneToOneField(
                blank=True,
                help_text="Subject allocation",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.allocation",
            ),
        ),
        migrations.AddIndex(
            model_name="assignment",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_46b9fc_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="assignment",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_0d441d_idx",
            ),
        ),
        migrations.AddField(
            model_name="allocation",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="historicalproduct",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="assignment",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddIndex(
            model_name="containerunits",
            index=models.Index(
                fields=["display_index", "display_name"],
                name="edc_pharmac_display_ff6b48_idx",
            ),
        ),
        migrations.AddField(
            model_name="container",
            name="units",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.containerunits",
            ),
        ),
        migrations.AddIndex(
            model_name="container",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_3a103a_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="container",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_cb1dc7_idx",
            ),
        ),
        migrations.AddField(
            model_name="dispense",
            name="location",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="dispense",
            name="registered_subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_registration.registeredsubject",
                verbose_name="Subject",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="dispense",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                help_text="Stock was dispensed",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.dispense",
                verbose_name="Dispense",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="dispense",
            field=models.OneToOneField(
                blank=True,
                help_text="Stock was dispensed",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.dispense",
                verbose_name="Dispense",
            ),
        ),
        migrations.AddField(
            model_name="historicalallocation",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="historicalallocation",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalallocation",
            name="registered_subject",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_registration.registeredsubject",
                verbose_name="Allocated to",
            ),
        ),
        migrations.AddField(
            model_name="historicalassignment",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalcontainer",
            name="container_type",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.containertype",
            ),
        ),
        migrations.AddField(
            model_name="historicalcontainer",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalcontainer",
            name="units",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.containerunits",
            ),
        ),
        migrations.AddField(
            model_name="historicaldispense",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicaldispense",
            name="location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="historicaldispense",
            name="registered_subject",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_registration.registeredsubject",
                verbose_name="Subject",
            ),
        ),
        migrations.AddField(
            model_name="historicallot",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="historicallot",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicallot",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.product",
            ),
        ),
        migrations.AddField(
            model_name="historicalorderitem",
            name="container",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"may_order_as": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="historicalorderitem",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalorderitem",
            name="order",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.order",
            ),
        ),
        migrations.AddField(
            model_name="historicalorderitem",
            name="product",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.product",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceive",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalreceive",
            name="location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"site__isnull": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceive",
            name="order",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.order",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceiveitem",
            name="container",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"may_receive_as": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceiveitem",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalrepackrequest",
            name="container",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"may_repack_as": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="historicalrepackrequest",
            name="from_stock",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"repack_request__isnull": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.stock",
            ),
        ),
        migrations.AddField(
            model_name="historicalrepackrequest",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequest",
            name="container",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"may_dispense_as": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequest",
            name="formulation",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.formulation",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequest",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequest",
            name="location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"site_id__isnull": False},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.location",
                verbose_name="Requested from",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequestitem",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequestitem",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequestitem",
            name="registered_subject",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_registration.registeredsubject",
                verbose_name="Subject",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequestitem",
            name="rx",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.rx",
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransfer",
            name="from_location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"site__isnull": True},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransfer",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransfer",
            name="to_location",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"site__isnull": False},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransferitem",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransferitem",
            name="stock",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                limit_choices_to={"allocation__isnull": False},
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.stock",
            ),
        ),
        migrations.AddField(
            model_name="historicalsupplier",
            name="history_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="lot",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="lot",
            name="product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.product",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceiveitem",
            name="lot",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.lot",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="lot",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.lot",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="lot",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.lot",
            ),
        ),
        migrations.AddField(
            model_name="orderitem",
            name="container",
            field=models.ForeignKey(
                limit_choices_to={"may_order_as": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="orderitem",
            name="order",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.order",
            ),
        ),
        migrations.AddField(
            model_name="orderitem",
            name="product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.product",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceiveitem",
            name="order_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.orderitem",
            ),
        ),
        migrations.AddField(
            model_name="receive",
            name="location",
            field=models.ForeignKey(
                limit_choices_to={"site__isnull": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="receive",
            name="order",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.order",
            ),
        ),
        migrations.AddField(
            model_name="historicalreceiveitem",
            name="receive",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.receive",
            ),
        ),
        migrations.AddField(
            model_name="receiveitem",
            name="container",
            field=models.ForeignKey(
                limit_choices_to={"may_receive_as": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="receiveitem",
            name="lot",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.lot",
            ),
        ),
        migrations.AddField(
            model_name="receiveitem",
            name="order_item",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.orderitem",
            ),
        ),
        migrations.AddField(
            model_name="receiveitem",
            name="receive",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.receive",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="receive_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.receiveitem",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="receive_item",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.receiveitem",
            ),
        ),
        migrations.AddField(
            model_name="repackrequest",
            name="container",
            field=models.ForeignKey(
                limit_choices_to={"may_repack_as": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="repackrequest",
            name="from_stock",
            field=models.ForeignKey(
                limit_choices_to={"repack_request__isnull": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="repack_requests",
                to="edc_pharmacy.stock",
            ),
        ),
        migrations.AddField(
            model_name="historicalstock",
            name="repack_request",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.repackrequest",
            ),
        ),
        migrations.AddField(
            model_name="stock",
            name="repack_request",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.repackrequest",
            ),
        ),
        migrations.AddField(
            model_name="stockrequest",
            name="container",
            field=models.ForeignKey(
                limit_choices_to={"may_dispense_as": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.container",
            ),
        ),
        migrations.AddField(
            model_name="stockrequest",
            name="formulation",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.formulation",
            ),
        ),
        migrations.AddField(
            model_name="stockrequest",
            name="location",
            field=models.ForeignKey(
                limit_choices_to={"site_id__isnull": False},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.location",
                verbose_name="Requested from",
            ),
        ),
        migrations.AddField(
            model_name="historicalstockrequestitem",
            name="stock_request",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.stockrequest",
                verbose_name="Stock request",
            ),
        ),
        migrations.AddField(
            model_name="stockrequestitem",
            name="assignment",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.assignment",
            ),
        ),
        migrations.AddField(
            model_name="stockrequestitem",
            name="registered_subject",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_registration.registeredsubject",
                verbose_name="Subject",
            ),
        ),
        migrations.AddField(
            model_name="stockrequestitem",
            name="rx",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.rx",
            ),
        ),
        migrations.AddField(
            model_name="stockrequestitem",
            name="stock_request",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.stockrequest",
                verbose_name="Stock request",
            ),
        ),
        migrations.AddField(
            model_name="historicalallocation",
            name="stock_request_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.stockrequestitem",
                verbose_name="Requested",
            ),
        ),
        migrations.AddField(
            model_name="allocation",
            name="stock_request_item",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.stockrequestitem",
                verbose_name="Requested",
            ),
        ),
        migrations.AddField(
            model_name="stocktransfer",
            name="from_location",
            field=models.ForeignKey(
                limit_choices_to={"site__isnull": True},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="from_location",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="stocktransfer",
            name="to_location",
            field=models.ForeignKey(
                limit_choices_to={"site__isnull": False},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="to_location",
                to="edc_pharmacy.location",
            ),
        ),
        migrations.AddField(
            model_name="historicalstocktransferitem",
            name="stock_transfer",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.stocktransfer",
            ),
        ),
        migrations.AddField(
            model_name="stocktransferitem",
            name="stock",
            field=models.OneToOneField(
                limit_choices_to={"allocation__isnull": False},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.stock",
            ),
        ),
        migrations.AddField(
            model_name="stocktransferitem",
            name="stock_transfer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.stocktransfer",
            ),
        ),
        migrations.AddField(
            model_name="historicalorder",
            name="supplier",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_pharmacy.supplier",
                verbose_name="Supplier",
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="supplier",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_pharmacy.supplier",
                verbose_name="Supplier",
            ),
        ),
        migrations.DeleteModel(
            name="GenericContainer",
        ),
        migrations.DeleteModel(
            name="HistoricalLabels",
        ),
        migrations.DeleteModel(
            name="HistoricalMedicationLot",
        ),
        migrations.DeleteModel(
            name="HistoricalStockCreateLabels",
        ),
        migrations.DeleteModel(
            name="HistoricalStockReceiving",
        ),
        migrations.DeleteModel(
            name="Labels",
        ),
        migrations.DeleteModel(
            name="MedicationLot",
        ),
        migrations.DeleteModel(
            name="PillBottle",
        ),
        migrations.DeleteModel(
            name="StockCreateLabels",
        ),
        migrations.DeleteModel(
            name="StockReceiving",
        ),
        migrations.DeleteModel(
            name="SubjectPillBottle",
        ),
        migrations.AddIndex(
            model_name="dispense",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_57ed59_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="dispense",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_31c262_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="lot",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_50c644_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="lot",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_227b04_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="orderitem",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_76214d_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="orderitem",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_cc450e_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="receive",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_ca1746_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="receive",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_661efc_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="receiveitem",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_a8e559_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="receiveitem",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_cdf3df_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="repackrequest",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_e9be1b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="repackrequest",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_e152ae_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stockrequest",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_296292_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stockrequest",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_02bc39_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stockrequestitem",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_338d5b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stockrequestitem",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_c76cb8_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="allocation",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_93b5ae_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="allocation",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_009406_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stocktransfer",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_c96f70_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stocktransfer",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_ebc1c6_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="stocktransferitem",
            index=models.Index(
                fields=["modified", "created"], name="edc_pharmac_modifie_975e7f_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="stocktransferitem",
            index=models.Index(
                fields=["user_modified", "user_created"],
                name="edc_pharmac_user_mo_36843e_idx",
            ),
        ),
    ]
