# Generated by Django 6.0 on 2025-03-14 12:47
from django.db import migrations
from tqdm import tqdm

from edc_pharmacy.models import StorageBinItem


def update_stored_at_site(apps, schema_editor):
    for obj in tqdm(StorageBinItem.objects.all(), total=StorageBinItem.objects.count()):
        stock = obj.stock
        stock.stored_at_site = True
        stock.save(update_fields=("stored_at_site",))


class Migration(migrations.Migration):

    dependencies = [
        ("edc_pharmacy", "0066_historicalstock_stored_at_site_stock_stored_at_site"),
    ]

    operations = [migrations.RunPython(update_stored_at_site)]
