from .base import ModuleTestBase


class TestDNSDumpster(ModuleTestBase):
    async def setup_after_prep(self, module_test):
        module_test.httpx_mock.add_response(
            url="https://dnsdumpster.com",
            headers={"Set-Cookie": "csrftoken=asdf"},
            content=b'<!DOCTYPE html>\n<html lang="en">\n  <head>\n\n    <meta charset="utf-8">\n    <meta http-equiv="X-UA-Compatible" content="IE=edge">\n<meta name="google-site-verification" content="vAWNZCy-5XAPGRgA2_NY5HictfnByvgpqOLQUAmVZW0" />\n    <meta name="viewport" content="width=device-width, initial-scale=1">\n    <meta name="description" content="Find dns records in order to identify the Internet footprint of an organization. Recon that enables deeper security assessments and discovery of the attack surface.">\n    <meta name="author" content="">\n    <link rel="icon" href="/static/favicon.ico">\n    <title>DNSdumpster.com - dns recon and research, find and lookup dns records</title>\n\n\n    <!-- Bootstrap core CSS -->\n    <link href="/static/css/bootstrap.min.css" rel="stylesheet">\n    <link href="/static/font-awesome/css/font-awesome.min.css" rel="stylesheet">\n\n    <!-- Custom styles for this template -->\n    <link href="/static/cover.css?v=1.4" rel="stylesheet">\n\n  </head>\n\n  <body>\n\n    <div class="site-wrapper">\n      <div class="site-wrapper-inner">\n<!-- Section 1 -->\n<section id="intro" data-speed="6" data-type="background">\n    <div class="container">\n\n   <div class="masthead clearfix">\n   <div class="container inner">\n        <nav>\n       <ul class="nav masthead-nav">\n   <li><a href="https://dnsdumpster.com/" data-toggle="tooltip"  data-placement="bottom" title="Home"><i style="font-size: 1.2em;" class="fa fa-home"></i></a></li>\n   <li><a href="/osint-network-defenders/"  data-toggle="tooltip"  data-placement="bottom" title="Defend"><i style="font-size: 1.2em;" class="fa fa-shield" aria-hidden="true"></i></a></li>\n   <li><a href="/footprinting-reconnaissance/" data-placement="bottom" data-toggle="tooltip" title="Learn"><i style="font-size: 1.2em;" class="fa fa-mortar-board" aria-hidden="true"></i></a></li>\n   <li><a href="https://hackertarget.com/" data-toggle="tooltip" title="Online Vulnerability Scanners"><i style="font-size: 1.2em; color: #00CC00;" class="fa fa-bullseye"></i></a></li>\n       </ul>\n        </nav>\n   </div>\n   </div>\n\n\n\n\n        <div class="cover-container" style="max-width: 900px;">\n          <div class="inner cover">\n            <h1 class="cover-heading" style="margin-top: 100px;">dns recon & research, find & lookup dns records</h1>\n<p class="lead">\n<div id="hideform">\n<form role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="XYxKkbdJJrio6VMqowCdykwpM4mAflKkF9BcKFbLdmPbB3lwXArEVJvTPNpIz50l">\n  <div class="form-group">\n<div class="col-md-2"></div><div class="col-md-6">\n\n<input class="form-control" type="text" placeholder="exampledomain.com" name="targetip" id="regularInput" autofocus>\n\n<input type="hidden" name="user" value="free">\n</div></div>\n<div align="left" id="formsubmit"><button type="submit" class="btn btn-default">Search <span class="glyphicon glyphicon-chevron-right"></span></button></div>\n</form></div></div>\n<div class="row"><div class="col-md-2"></div><div class="col-md-8">\n<div id="showloading" style="color: #fff;">Loading...<br>\n<div class="progress">\n<div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 100%">\n</div></div></div></div></div></div>\n</P>\n\n<div class="row"><div class="col-md-12" style="padding: 80px;">\n\n</div></div>\n\n<p class="lead" style="margin-top: 40px; margin-bottom: 30px;">DNSdumpster.com is a FREE domain research tool that can discover hosts related to a domain. Finding visible hosts from the attackers perspective is an important part of the security assessment process.</p>\n\n          </div>\n\n              <p style="color: #777; margin-top: 40px;">this is a <a href="https://hackertarget.com/" title="Online Vulnerability Scanners"><button type="button" class="btn btn-danger btn-xs">HackerTarget.com</button></a> project</p>\n\n\n      <div style="margin-top: 160px;" class="container">\n        <div class="row">\n          <div class="col-lg-12 text-center">\n            <h2 class="section-heading text-uppercase"></h2>\n            <h3 class="section-subheading text-muted">Open Source Intelligence for Networks</h3>\n          </div>\n        </div>\n        <div style="margin-top: 30px;" class="row text-center">\n          <div class="col-md-4">\n            <span class="fa-stack fa-4x">\n              <i class="fa fa-user-secret fa-stack-1x" style="color: #00CC00;"></i>\n            </span>\n            <h4 class="service-heading">Attack</h4>\n            <p class="text-muted">The ability to quickly identify the attack surface is essential. Whether you are penetration testing or chasing bug bounties.</p>\n          </div>\n          <div class="col-md-4">\n            <span class="fa-stack fa-4x">\n              <i class="fa fa-shield fa-stack-1x" style="color: #00CC00;"></i>\n            </span>\n            <h4 class="service-heading">Defend</h4>\n            <p class="text-muted">Network defenders benefit from passive reconnaissance in a number of ways. With analysis informing information security strategy.</p>\n          </div>\n          <div class="col-md-4">\n            <span class="fa-stack fa-4x">\n              <i class="fa fa-mortar-board fa-stack-1x" style="color: #00CC00;"></i>\n            </span>\n            <h4 class="service-heading">Learn</h4>\n            <p class="text-muted">Understanding network based OSINT helps information technologists to better operate, assess and manage the network.</p>\n          </div>\n        </div>\n      </div>\n\n\n\n\n    <div class="container" style="background-color: #474747; margin-top: 180px; padding-bottom: 80px;"><div class="col-md-2"></div><div class="col-md-8">\n\n       <span class="glyphicon glyphicon-trash" style="font-size: 4em; line-height: 5.5em;"></span>\n<p style="font-size: 1.7em; line-height: 1.9em; margin-bottom: 80px;">Map an organizations attack surface with a virtual <i>dumpster dive*</i> of the DNS records associated with the target organization.</p>\n<p style="font-size: 1.2em; color: #fff;">*DUMPSTER DIVING: The practice of sifting refuse from an office or technical installation to extract confidential data, especially security-compromising information.</p>\n</div>    </div>\n\n\n<div class="container" style="text-align: left; margin-top: 80px; margin-bottom: 80px;">\n\n<h2 style="font-size: 1.8em;">Frequently Asked Questions</h2>\n\n<h4 style="margin-top: 30px;">How can I take my security assessments to the next level?</h4>\n\n<p>The company behind DNSDumpster is <a href="https://hackertarget.com/" title="Online Vulnerability Scanners">hackertarget.com</a> where we provide online hosted access to trusted open source security vulnerability scanners and network intelligence tools.</P><P>Save time and headaches by incorporating our attack surface discovery into your vulnerability assessment process.</p><P style="text-align: center; padding: 30px;"><a href="https://hackertarget.com/" title="HackerTarget.com | Online Security Testing and Open Source Intelligence"><img src="https://hackertarget.com/wp-content/uploads/2019/09/know-your-network-tools.png" alt="HackerTarget.com | Online Security Testing and Open Source Intelligence"></a></p>\n\n<h4>What data does DNSDumpster use?</h4>\n\n<p>No brute force subdomain enumeration is used as is common in dns recon tools that enumerate subdomains. We use open source intelligence resources to query for related domain data. It is then compiled into an actionable resource for both attackers and defenders of Internet facing systems.</P>\n<P>More than a simple <a href="https://hackertarget.com/dns-lookup/" title="Online DNS Lookup">DNS lookup</a> this tool will discover those hard to find sub-domains and web hosts. The search relies on data from our crawls of the Alexa Top 1 Million sites, Search Engines, Common Crawl, Certificate Transparency, Max Mind, Team Cymru, Shodan and <a href="https://scans.io/" style="text-decoration: underline;">scans.io</a>.</P>\n\n<h4>I have hit the host limit, do you have a PRO option?</h4>\n\n<P>Over at <a href="https://hackertarget.com/" title="Online Vulnerability Scanners">hackertarget.com</a> there\'s a tool we call <a href="https://hackertarget.com/domain-profiler/">domain profiler</a>. This compiles data similar to DNSDumpster; with additional data discovery. Queries available are based on the membership plan with the number of results (subdomains) being unlimited. With a STARTER membership you have access to the domain profiler tool for 12 months. Once the years membership expires you will revert to BASIC member status, however access to Domain Profiler and Basic Nmap scans continue. The BASIC access does not expire.</P>\n\n<h4>What are some other resources and tools for learning more?</h4>\n\n<P>There are some great open source recon frameworks that have been developed over the past couple of years. In addition tools such as <b>Metasploit</b> and <b>Nmap</b> include various modules for enumerating DNS. Check our <a href="https://dnsdumpster.com/footprinting-reconnaissance/">Getting Started with Footprinting</a> for more information.</P>\n\n</div>\n\n\n</div></div>\n</div></div>\n\n<footer>\n<div class="row" style="background-color: #1e1e1e; padding-top: 40px; padding-bottom: 20px;"><div class="container">\n<div class="col-md-6 col-sm-12 right-border" style="text-align: center;">\n<div class="footer-about" style="text-align: left; padding-left: 40px;">\n<h2 class="footer-title" style="font-size: 1.8em;">About</h2>\n<p style="margin-top: 20px;">At <a href="https://hackertarget.com/">hackertarget.com</a>, we have been scanning the Internet since 2007. Our vulnerability scanners now reach millions of IP addresses every year. We work to raise awareness of the value in open source security solutions.</p>\n</div>\n</div>\n<div class="col-md-6 col-sm-12">\n<div class="contact-info" style="text-align: left; padding-left: 40px;">\n<h2 class="footer-title" style="font-size: 1.8em;">Stay in Touch</h2>\n\n<div class="single">\n        <p><i style="font-size: 1.2em;" class="fa fa-envelope"></i> dnsdumpster@gmail.com</p>\n</div>\n<div class="single">\n        <p><i style="font-size: 1.2em;" class="fa fa-twitter"></i> <a href="https://twitter.com/hackertarget/">@hackertarget</a></p>\n</div>\n<!-- Begin MailChimp Signup Form -->\n<link href="https://cdn-images.mailchimp.com/embedcode/horizontal-slim-10_7.css" rel="stylesheet" type="text/css">\n<style type="text/css">\n    #mc_embed_signup{background:#1e1e1e; clear:left; font:14px Helvetica,Arial,sans-serif; width:100%;}\n        /* Add your own MailChimp form style overrides in your site stylesheet or in this style block.\n               We recommend moving this block and the preceding CSS link to the HEAD of your HTML file. */\n               </style>\n               <div id="mc_embed_signup">\n               <form action="https://dnsdumpster.us17.list-manage.com/subscribe/post?u=3cbc62d931a69e74b2c856f1a&amp;id=532c46ab39" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>\n                   <div id="mc_embed_signup_scroll" style="text-align: left;">\n\n                        <input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL" placeholder="email address" required>\n                            <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\n                                <div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_3cbc62d931a69e74b2c856f1a_532c46ab39" tabindex="-1" value=""></div><br>\n                                    <div class="clear" style="margin-top: 5px;"><input type="submit" style="background-color: #00CC00;" value="Subscribe to our List" name="subscribe" id="mc-embedded-subscribe" class="button"> <span style="font-size: 0.8em;">Low volume Updates and News</a></div>\n                                        </div>\n                                        </form>\n                                        </div>\n\n                                        <!--End mc_embed_signup-->\n\n</div>\n</div>\n</div>\n<div class="clearfix"></div>\n<div class="copyright" style="background-color: #1e1e1e; margin-top: 20px;">\n<p>Copyright &copy; 2023 Hacker Target Pty Ltd</p>\n</div>\n</div>\n</div>\n</div>\n</footer>\n                                                </div>\n                                        </div>\n                                </div>\n                        </div>\n\n\n\n\n</div></div>\n\n    <!-- Bootstrap core JavaScript\n    ================================================== -->\n    <!-- Placed at the end of the document so the pages load faster -->\n    <script src="https://dnsdumpster.com/static/js/jquery-1.12.4.min.js"></script>\n    <script src="/static/js/bootstrap.min.js"></script>\n\n\n\n<script type="text/javascript">\n            $(document).ready(function() {\n$(\'[data-toggle="tooltip"]\').tooltip({\'placement\': \'top\'});\n\n$("body").on(\'DOMSubtreeModified\', ".modal-content", function() {\n    $(".modal-heading").hide();\n    $(".modal-content").show();\n});\n\n      $(\'body\').on(\'hidden.bs.modal\', \'.modal\', function () {\n        $(this).removeData(\'bs.modal\');\n      });\n\n            }); //END $(document).ready()\n\n\n$(\'a.external\').on(\'click\', function(e) {\n        e.preventDefault();\n        $(".modal-heading").show();\n        $(".modal-content").hide();\n\n\n        var url = $(this).attr(\'href\');\n        $(".modal-body").html(\'<iframe id="myiframe" style="background-color: #ccc;" width="100%" height="100%" frameborder="0" scrolling="yes" allowtransparency="true" src="\'+url+\'"></iframe>\');\n    });\n\n \n\n\n    $(\'#myModal\').on(\'show.bs.modal\', function () {\n        $(this).find(\'.modal-dialog\').css({\n                  width:\'80%\', //choose your width\n                  height:\'80%\',\n                  \'padding\':\'5\'\n           });\n         $(this).find(\'.modal-content\').css({\n                  height:\'100%\',\n                  \'border-radius\':\'0\',\n                  \'padding\':\'15\'\n           });\n         $(this).find(\'.modal-body\').html(null);\n         $(this).find(\'.modal-body\').css({\n                  width:\'auto\',\n                  height:\'100%\',\n                  \'padding\':\'5\'\n           });\n    })\n\n        </script>\n\n<script>\n$(document).ready(function(){\n  $("#showloading").hide();\n  $("#formsubmit").click(function(){\n    $("#hideform").hide();\n    $("#showloading").show();\n  });\n\n});\n</script>\n<!-- Google tag (gtag.js) -->\n<script async src="https://www.googletagmanager.com/gtag/js?id=G-FPGN9YXFNE"></script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag(\'js\', new Date());\n\n  gtag(\'config\', \'G-FPGN9YXFNE\');\n</script>\n  </body>\n</html>\n',
        )
        module_test.httpx_mock.add_response(
            url="https://dnsdumpster.com/",
            method="POST",
            content=b'<!DOCTYPE html>\n<html lang="en">\n  <head>\n\n    <meta charset="utf-8">\n    <meta http-equiv="X-UA-Compatible" content="IE=edge">\n<meta name="google-site-verification" content="vAWNZCy-5XAPGRgA2_NY5HictfnByvgpqOLQUAmVZW0" />\n    <meta name="viewport" content="width=device-width, initial-scale=1">\n    <meta name="description" content="Find dns records in order to identify the Internet footprint of an organization. Recon that enables deeper security assessments and discovery of the attack surface.">\n    <meta name="author" content="">\n    <link rel="icon" href="/static/favicon.ico">\n    <title>DNSdumpster.com - dns recon and research, find and lookup dns records</title>\n\n\n    <!-- Bootstrap core CSS -->\n    <link href="/static/css/bootstrap.min.css" rel="stylesheet">\n    <link href="/static/font-awesome/css/font-awesome.min.css" rel="stylesheet">\n\n    <!-- Custom styles for this template -->\n    <link href="/static/cover.css?v=1.4" rel="stylesheet">\n\n  </head>\n\n  <body>\n\n    <div class="site-wrapper">\n      <div class="site-wrapper-inner">\n<!-- Section 1 -->\n<section id="intro" data-speed="6" data-type="background">\n    <div class="container">\n\n   <div class="masthead clearfix">\n   <div class="container inner">\n        <nav>\n       <ul class="nav masthead-nav">\n   <li><a href="https://dnsdumpster.com/" data-toggle="tooltip"  data-placement="bottom" title="Home"><i style="font-size: 1.2em;" class="fa fa-home"></i></a></li>\n   <li><a href="/osint-network-defenders/"  data-toggle="tooltip"  data-placement="bottom" title="Defend"><i style="font-size: 1.2em;" class="fa fa-shield" aria-hidden="true"></i></a></li>\n   <li><a href="/footprinting-reconnaissance/" data-placement="bottom" data-toggle="tooltip" title="Learn"><i style="font-size: 1.2em;" class="fa fa-mortar-board" aria-hidden="true"></i></a></li>\n   <li><a href="https://hackertarget.com/" data-toggle="tooltip" title="Online Vulnerability Scanners"><i style="font-size: 1.2em; color: #00CC00;" class="fa fa-bullseye"></i></a></li>\n       </ul>\n        </nav>\n   </div>\n   </div>\n\n\n\n\n        <div class="cover-container" style="max-width: 900px;">\n          <div class="inner cover">\n            <h1 class="cover-heading" style="margin-top: 100px;">dns recon & research, find & lookup dns records</h1>\n<p class="lead">\n<div id="hideform">\n<form role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS">\n  <div class="form-group">\n<div class="col-md-2"></div><div class="col-md-6">\n\n<input class="form-control" type="text" placeholder="exampledomain.com" name="targetip" id="regularInput" autofocus>\n\n<input type="hidden" name="user" value="free">\n</div></div>\n<div align="left" id="formsubmit"><button type="submit" class="btn btn-default">Search <span class="glyphicon glyphicon-chevron-right"></span></button></div>\n</form></div></div>\n<div class="row"><div class="col-md-2"></div><div class="col-md-8">\n<div id="showloading" style="color: #fff;">Loading...<br>\n<div class="progress">\n<div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 100%">\n</div></div></div></div></div></div>\n</P>\n\n<div class="row"><div class="col-md-12" style="padding: 80px;">\n\n<p><h4 style="color: #00CC00; text-align: left; font-size: 1.5em; line-height: 2.7em;">Showing results for <span style="font-weight: 700;">blacklanternsecurity.com</span></h4></p>\n<div style="text-align: right; font-size: 1em;"><a href="#dnsanchor"><span class="label label-default">DNS Servers</span></a> <a href="#mxanchor"><span class="label label-default">MX Records</span></a> <a href="#txtanchor"><span class="label label-default">TXT Records</span></a> <a href="#hostanchor"><span class="label label-default">Host (A) Records</span></a> <a href="#domainmap"><span class="label label-default">Domain Map</span></a></div><div class="clearfix" style="height: 30px;"></div>\n<div class="container">\n    <div class="row">\n        <div class="col-md-4">\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left; padding-left: 30px; padding-bottom: 20px;">Hosting (IP block owners)</P>\n<canvas id="hosting" height="380" width="300"></canvas></div>\n        <div class="col-md-8">\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left; padding-left: 30px;">GeoIP of Host Locations</P>\n  <div id="world-map" style="width: 480px; height: 380px"></div>\n</div>                        </div>\n</div>\n\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left;"><a name="dnsanchor"></a>DNS Servers</P>\n<div class="table-responsive" style="text-align: left;">\n  <table class="table" style="font-size: 1.1em; border-color: #777;">\n \n   <tr><td class="col-md-4">ns01.domaincontrol.com.<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=ns01.domaincontrol.com." data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers from IP address (Active)"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/zonetransfer/?q=ns01.domaincontrol.com." data-target="#myModal"><span class="glyphicon glyphicon-log-in" data-toggle="tooltip" data-placement="top" title="Attempt Zone Transfer (Active)"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=97.74.100.1" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path to IP address using MTR (Active)"></span></a> <a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/findshareddns/?q=ns01.domaincontrol.com." data-target="#myModal"><span class="glyphicon glyphicon-cloud-download" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this DNS server"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="97.74.100.0/23" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="97.74.100.1" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n</td><td class="col-md-3">97.74.100.1<br><span style="font-size: 0.9em; color: #eee;">ns01.domaincontrol.com</span></td><td class="col-md-3">GODADDY-DNS<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">ns02.domaincontrol.com.<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=ns02.domaincontrol.com." data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers from IP address (Active)"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/zonetransfer/?q=ns02.domaincontrol.com." data-target="#myModal"><span class="glyphicon glyphicon-log-in" data-toggle="tooltip" data-placement="top" title="Attempt Zone Transfer (Active)"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=173.201.68.1" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path to IP address using MTR (Active)"></span></a> <a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/findshareddns/?q=ns02.domaincontrol.com." data-target="#myModal"><span class="glyphicon glyphicon-cloud-download" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this DNS server"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="173.201.68.0/23" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="173.201.68.1" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n</td><td class="col-md-3">173.201.68.1<br><span style="font-size: 0.9em; color: #eee;">ns02.domaincontrol.com</span></td><td class="col-md-3">GODADDY-DNS<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n   \n  </table>\n</div>\n\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left;"><a name="mxanchor"></a>MX Records <span style="font-size: 0.8em; color: #777;">** This is where email for the domain goes...</P>\n<div class="table-responsive" style="text-align: left;">\n  <table class="table" style="font-size: 1.1em; font-family: \'Courier New\', Courier, monospace;">\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com.mail.protection.outlook.com.<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=104.47.55.138" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=104.47.55.138" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="104.40.0.0/13" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="104.47.55.138" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n</td><td class="col-md-3">104.47.55.138<br><span style="font-size: 0.9em; color: #eee;">mail-bn8nam120138.inbound.protection.outlook.com</span></td><td class="col-md-3">MICROSOFT-CORP-MSN-AS-BLOCK<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n   \n  </table>\n</div>\n\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left;"><a name="txtanchor"></a>TXT Records <span style="font-size: 0.8em; color: #777;">** Find more hosts in Sender Policy Framework (SPF) configurations</span></P>\n<div class="table-responsive" style="text-align: left;">\n  <table class="table" style="font-size: 1.1em; font-family: \'Courier New\', Courier, monospace;">\n\n<tr><td>&quot;MS=ms26206678&quot;</td></tr>\n\n<tr><td>&quot;v=spf1 ip4:50.240.76.25 include:spf.protection.outlook.com -all&quot;</td></tr>\n\n<tr><td>&quot;google-site-verification=O_PoQFTGJ_hZ9LqfNT9OEc0KPFERKHQ_1t1m0YTx_1E&quot;</td></tr>\n\n<tr><td>&quot;google-site-verification=7XKUMxJSTHBSzdvT7gH47jLRjNAS76nrEfXmzhR_DO4&quot;</td></tr>\n\n</table>\n</div>\n\n\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left;"><a name="hostanchor"></a>Host Records (A) <span style="font-size: 0.8em; color: #777;">** this data may not be current as it uses a static database (updated monthly)</span> </P>\n<div class="table-responsive" style="text-align: left;">\n  <table class="table" style="font-size: 1.1em; font-family: \'Courier New\', Courier, monospace;">\n\n \n   <tr><td class="col-md-4">blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=185.199.108.153" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=185.199.108.153" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="185.199.108.0/24" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="185.199.108.153" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n<br><span style="font-size: 0.8em; color: #bbb;">HTTP: </span>\n <span style="font-size: 0.9em; color: #eee; color: #0C0;"  data-toggle="tooltip" data-placement="top" title="HTTP Server found in Global Scan data (Passive)">GitHub.com</span>\n\n\n\n\n\n\n\n\n<br><span style="font-size: 0.8em; color: #bbb;">HTTP TECH: </span>\n <span style="font-size: 0.9em; color: #eee; color: #0C0;"  data-toggle="tooltip" data-placement="top" title="Apps / Technologies found in Global Scan data (Passive)">varnish</span>\n\n\n\n</td><td class="col-md-3">185.199.108.153<br><span style="font-size: 0.9em; color: #eee;">cdn-185-199-108-153.github.com</span></td><td class="col-md-3">FASTLY<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=143.244.156.80" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://asdf.blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=143.244.156.80" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="143.244.144.0/20" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="143.244.156.80" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n\n\n\n<br><span style="font-size: 0.8em; color: #bbb;">SSH: </span>\n <span style="font-size: 0.9em; color: #eee; color: #0C0;"  data-toggle="tooltip" data-placement="top" title="SSH Server found in Global Scan data (Passive)">SSH-2.0-OpenSSH_8.2p1 Ubuntu-4ubuntu0.3</span>\n\n\n\n\n\n\n\n</td><td class="col-md-3">143.244.156.80<br><span style="font-size: 0.9em; color: #eee;">asdf.blacklanternsecurity.com</span></td><td class="col-md-3">DIGITALOCEAN-ASN<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=64.227.8.231" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://asdf.blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=64.227.8.231" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="64.227.0.0/20" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="64.227.8.231" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n<br><span style="font-size: 0.8em; color: #bbb;">HTTP: </span>\n <span style="font-size: 0.9em; color: #eee; color: #0C0;"  data-toggle="tooltip" data-placement="top" title="HTTP Server found in Global Scan data (Passive)">Apache/2.4.29 (Ubuntu)</span>\n\n\n\n\n\n\n\n\n<br><span style="font-size: 0.8em; color: #bbb;">HTTP TECH: </span>\n <span style="font-size: 0.9em; color: #eee; color: #0C0;"  data-toggle="tooltip" data-placement="top" title="Apps / Technologies found in Global Scan data (Passive)">Ubuntu<br>Apache,2.4.29</span>\n\n\n\n</td><td class="col-md-3">64.227.8.231<br><span style="font-size: 0.9em; color: #eee;">asdf.blacklanternsecurity.com</span></td><td class="col-md-3">DIGITALOCEAN-ASN<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=192.34.56.157" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://asdf.blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=192.34.56.157" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="192.34.56.0/24" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="192.34.56.157" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n\n\n\n\n\n\n\n\n\n</td><td class="col-md-3">192.34.56.157<br><span style="font-size: 0.9em; color: #eee;">asdf.blacklanternsecurity.com</span></td><td class="col-md-3">DIGITALOCEAN-ASN<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=192.241.216.208" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://asdf.blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=192.241.216.208" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="192.241.192.0/19" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="192.241.216.208" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n\n\n\n\n\n\n\n\n\n</td><td class="col-md-3">192.241.216.208<br><span style="font-size: 0.9em; color: #eee;">asdf.blacklanternsecurity.com</span></td><td class="col-md-3">DIGITALOCEAN-ASN<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=167.71.95.71" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://asdf.blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=167.71.95.71" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="167.71.80.0/20" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="167.71.95.71" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n\n\n\n\n\n\n\n\n\n</td><td class="col-md-3">167.71.95.71<br><span style="font-size: 0.9em; color: #eee;">asdf.blacklanternsecurity.com</span></td><td class="col-md-3">DIGITALOCEAN-ASN<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n \n   <tr><td class="col-md-4">asdf.blacklanternsecurity.com<br>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/reverseiplookup/?q=157.245.247.197" data-target="#myModal"><span class="glyphicon glyphicon-th" data-toggle="tooltip" data-placement="top" title="Find hosts sharing this IP address"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/httpheaders/?q=http://asdf.blacklanternsecurity.com" data-target="#myModal"><span class="glyphicon glyphicon-globe" data-toggle="tooltip" data-placement="top" title="Get HTTP Headers"></span></a>\n<a class="external nounderline" data-toggle="modal" href="https://api.hackertarget.com/mtr/?q=157.245.247.197" data-target="#myModal"><span class="glyphicon glyphicon-random" data-toggle="tooltip" data-placement="top" title="Trace path"></span></a>\n<form style="display: inline;" role="form" action="." method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="157.245.240.0/20" name="targetip"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Search Banners for Netblock (Passive)"><span class="glyphicon glyphicon-eye-open"></span></button></form>\n<form style="display: inline;" role="form" action="https://hackertarget.com/nmap-online-port-scanner/" target="_blank" method="post"><input type="hidden" name="csrfmiddlewaretoken" value="FNUVMI6wikKoeDeCNL9cFyiCnsxbycmxnwLAffFtp8wzEwJEc1lJHpmrmZFVDxiS"><input type="hidden" value="157.245.247.197" name="send_scan[]"><button class="submit-with-icon" type="submit" data-toggle="tooltip" data-placement="top" title="Nmap Port Scan (Active)"><span class="glyphicon glyphicon-screenshot" style="color: #0C0;"></span></button></form>\n<!--  -->\n\n\n\n\n\n\n\n\n\n\n</td><td class="col-md-3">157.245.247.197<br><span style="font-size: 0.9em; color: #eee;">asdf.blacklanternsecurity.com</span></td><td class="col-md-3">DIGITALOCEAN-ASN<br><span style="font-size: 0.9em; color: #eee;">United States</span></td></tr>\n   \n  </table>\n<br>\n\n\n\n<div style="margin: 30px;" align="center"><a href="/static/asdf.blacklanternsecurity.com-202305190301.xlsx"><button type="button" class="btn btn-default"><span class="glyphicon glyphicon-download" aria-hidden="true"></span> Download .xlsx of Hosts</button></a> <a href="/static/asdf.blacklanternsecurity.com-202305190301.html" target="_blank"><button type="button" class="btn btn-default"><span class="glyphicon glyphicon-download" aria-hidden="true"></span> View Graph (beta)</button></div>\n\n<br>\n<p style="color: #ddd; font-family: \'Courier New\', Courier, monospace; text-align: left;"><a name="domainmap"></a>Mapping the domain<span style="font-size: 0.8em; color: #777;"> ** click for full size image</span> </P>\n<p>\n<a href="/static/asdf.blacklanternsecurity.com.png"><img style="max-width: 100%;" class="img-responsive"  src="/static/asdf.blacklanternsecurity.com.png"></a>\n</p>\n</div>\n\n</div></div>\n\n<p class="lead" style="margin-top: 40px; margin-bottom: 30px;">DNSdumpster.com is a FREE domain research tool that can discover hosts related to a domain. Finding visible hosts from the attackers perspective is an important part of the security assessment process.</p>\n\n          </div>\n\n              <p style="color: #777; margin-top: 40px;">this is a <a href="https://hackertarget.com/" title="Online Vulnerability Scanners"><button type="button" class="btn btn-danger btn-xs">HackerTarget.com</button></a> project</p>\n\n\n      <div style="margin-top: 160px;" class="container">\n        <div class="row">\n          <div class="col-lg-12 text-center">\n            <h2 class="section-heading text-uppercase"></h2>\n            <h3 class="section-subheading text-muted">Open Source Intelligence for Networks</h3>\n          </div>\n        </div>\n        <div style="margin-top: 30px;" class="row text-center">\n          <div class="col-md-4">\n            <span class="fa-stack fa-4x">\n              <i class="fa fa-user-secret fa-stack-1x" style="color: #00CC00;"></i>\n            </span>\n            <h4 class="service-heading">Attack</h4>\n            <p class="text-muted">The ability to quickly identify the attack surface is essential. Whether you are penetration testing or chasing bug bounties.</p>\n          </div>\n          <div class="col-md-4">\n            <span class="fa-stack fa-4x">\n              <i class="fa fa-shield fa-stack-1x" style="color: #00CC00;"></i>\n            </span>\n            <h4 class="service-heading">Defend</h4>\n            <p class="text-muted">Network defenders benefit from passive reconnaissance in a number of ways. With analysis informing information security strategy.</p>\n          </div>\n          <div class="col-md-4">\n            <span class="fa-stack fa-4x">\n              <i class="fa fa-mortar-board fa-stack-1x" style="color: #00CC00;"></i>\n            </span>\n            <h4 class="service-heading">Learn</h4>\n            <p class="text-muted">Understanding network based OSINT helps information technologists to better operate, assess and manage the network.</p>\n          </div>\n        </div>\n      </div>\n\n\n\n\n    <div class="container" style="background-color: #474747; margin-top: 180px; padding-bottom: 80px;"><div class="col-md-2"></div><div class="col-md-8">\n\n       <span class="glyphicon glyphicon-trash" style="font-size: 4em; line-height: 5.5em;"></span>\n<p style="font-size: 1.7em; line-height: 1.9em; margin-bottom: 80px;">Map an organizations attack surface with a virtual <i>dumpster dive*</i> of the DNS records associated with the target organization.</p>\n<p style="font-size: 1.2em; color: #fff;">*DUMPSTER DIVING: The practice of sifting refuse from an office or technical installation to extract confidential data, especially security-compromising information.</p>\n</div>    </div>\n\n\n<div class="container" style="text-align: left; margin-top: 80px; margin-bottom: 80px;">\n\n<h2 style="font-size: 1.8em;">Frequently Asked Questions</h2>\n\n<h4 style="margin-top: 30px;">How can I take my security assessments to the next level?</h4>\n\n<p>The company behind DNSDumpster is <a href="https://hackertarget.com/" title="Online Vulnerability Scanners">hackertarget.com</a> where we provide online hosted access to trusted open source security vulnerability scanners and network intelligence tools.</P><P>Save time and headaches by incorporating our attack surface discovery into your vulnerability assessment process.</p><P style="text-align: center; padding: 30px;"><a href="https://hackertarget.com/" title="HackerTarget.com | Online Security Testing and Open Source Intelligence"><img src="https://hackertarget.com/wp-content/uploads/2019/09/know-your-network-tools.png" alt="HackerTarget.com | Online Security Testing and Open Source Intelligence"></a></p>\n\n<h4>What data does DNSDumpster use?</h4>\n\n<p>No brute force subdomain enumeration is used as is common in dns recon tools that enumerate subdomains. We use open source intelligence resources to query for related domain data. It is then compiled into an actionable resource for both attackers and defenders of Internet facing systems.</P>\n<P>More than a simple <a href="https://hackertarget.com/dns-lookup/" title="Online DNS Lookup">DNS lookup</a> this tool will discover those hard to find sub-domains and web hosts. The search relies on data from our crawls of the Alexa Top 1 Million sites, Search Engines, Common Crawl, Certificate Transparency, Max Mind, Team Cymru, Shodan and <a href="https://scans.io/" style="text-decoration: underline;">scans.io</a>.</P>\n\n<h4>I have hit the host limit, do you have a PRO option?</h4>\n\n<P>Over at <a href="https://hackertarget.com/" title="Online Vulnerability Scanners">hackertarget.com</a> there\'s a tool we call <a href="https://hackertarget.com/domain-profiler/">domain profiler</a>. This compiles data similar to DNSDumpster; with additional data discovery. Queries available are based on the membership plan with the number of results (subdomains) being unlimited. With a STARTER membership you have access to the domain profiler tool for 12 months. Once the years membership expires you will revert to BASIC member status, however access to Domain Profiler and Basic Nmap scans continue. The BASIC access does not expire.</P>\n\n<h4>What are some other resources and tools for learning more?</h4>\n\n<P>There are some great open source recon frameworks that have been developed over the past couple of years. In addition tools such as <b>Metasploit</b> and <b>Nmap</b> include various modules for enumerating DNS. Check our <a href="https://dnsdumpster.com/footprinting-reconnaissance/">Getting Started with Footprinting</a> for more information.</P>\n\n</div>\n\n\n\n<!-- Modal -->\n<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">\n  <div class="modal-dialog">\n<div class="modal-heading lds-facebook" style="margin-top: 200px;"><div></div><div></div><div></div></div>\n    <div class="modal-content" style="background-color: #CCC; white-space: pre-wrap; padding: 20px; text-shadow: none; font-size: 1.2em; max-width: 1000px;">\n      </div><!-- /.modal-content -->\n  </div><!-- /.modal-dialog -->\n</div><!-- /.modal -->\n\n</div></div>\n</div></div>\n\n<footer>\n<div class="row" style="background-color: #1e1e1e; padding-top: 40px; padding-bottom: 20px;"><div class="container">\n<div class="col-md-6 col-sm-12 right-border" style="text-align: center;">\n<div class="footer-about" style="text-align: left; padding-left: 40px;">\n<h2 class="footer-title" style="font-size: 1.8em;">About</h2>\n<p style="margin-top: 20px;">At <a href="https://hackertarget.com/">hackertarget.com</a>, we have been scanning the Internet since 2007. Our vulnerability scanners now reach millions of IP addresses every year. We work to raise awareness of the value in open source security solutions.</p>\n</div>\n</div>\n<div class="col-md-6 col-sm-12">\n<div class="contact-info" style="text-align: left; padding-left: 40px;">\n<h2 class="footer-title" style="font-size: 1.8em;">Stay in Touch</h2>\n\n<div class="single">\n        <p><i style="font-size: 1.2em;" class="fa fa-envelope"></i> dnsdumpster@gmail.com</p>\n</div>\n<div class="single">\n        <p><i style="font-size: 1.2em;" class="fa fa-twitter"></i> <a href="https://twitter.com/hackertarget/">@hackertarget</a></p>\n</div>\n<!-- Begin MailChimp Signup Form -->\n<link href="https://cdn-images.mailchimp.com/embedcode/horizontal-slim-10_7.css" rel="stylesheet" type="text/css">\n<style type="text/css">\n    #mc_embed_signup{background:#1e1e1e; clear:left; font:14px Helvetica,Arial,sans-serif; width:100%;}\n        /* Add your own MailChimp form style overrides in your site stylesheet or in this style block.\n               We recommend moving this block and the preceding CSS link to the HEAD of your HTML file. */\n               </style>\n               <div id="mc_embed_signup">\n               <form action="https://dnsdumpster.us17.list-manage.com/subscribe/post?u=3cbc62d931a69e74b2c856f1a&amp;id=532c46ab39" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>\n                   <div id="mc_embed_signup_scroll" style="text-align: left;">\n\n                        <input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL" placeholder="email address" required>\n                            <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\n                                <div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_3cbc62d931a69e74b2c856f1a_532c46ab39" tabindex="-1" value=""></div><br>\n                                    <div class="clear" style="margin-top: 5px;"><input type="submit" style="background-color: #00CC00;" value="Subscribe to our List" name="subscribe" id="mc-embedded-subscribe" class="button"> <span style="font-size: 0.8em;">Low volume Updates and News</a></div>\n                                        </div>\n                                        </form>\n                                        </div>\n\n                                        <!--End mc_embed_signup-->\n\n</div>\n</div>\n</div>\n<div class="clearfix"></div>\n<div class="copyright" style="background-color: #1e1e1e; margin-top: 20px;">\n<p>Copyright &copy; 2023 Hacker Target Pty Ltd</p>\n</div>\n</div>\n</div>\n</div>\n</footer>\n                                                </div>\n                                        </div>\n                                </div>\n                        </div>\n\n\n\n\n</div></div>\n\n    <!-- Bootstrap core JavaScript\n    ================================================== -->\n    <!-- Placed at the end of the document so the pages load faster -->\n    <script src="https://dnsdumpster.com/static/js/jquery-1.12.4.min.js"></script>\n    <script src="/static/js/bootstrap.min.js"></script>\n\n\n<script src="/static/Chart.js"></script>\n  <link rel="stylesheet" href="/static/jquery-jvectormap-2.0.1.css" type="text/css" media="screen"/>\n  <script src="/static/jquery-jvectormap-2.0.1.min.js"></script>\n  <script src="/static/jquery-jvectormap-world-mill-en.js"></script>\n\n   <script type="text/javascript">\nvar barChartData = {\nlabels : [\n\n"GODADDY-DNS",\n\n"MICROSOFT-CORP-MSN-AS-BLOCK",\n\n"FASTLY",\n\n"DIGITALOCEAN-ASN",\n\n],\ndatasets : [\n{\nfillColor : "#ccc",\nstrokeColor : "#ccc",\ndata : [\n\n2,\n\n1,\n\n1,\n\n6,\n\n],\n}\n]\n}\n\nwindow.onload = function(){\nvar ctx = document.getElementById("hosting").getContext("2d");\nwindow.myBar = new Chart(ctx).Bar(barChartData, {\n});\n}\n</script>\n\n\n<script>\nvar gdpData = {\n\n"US" : 3,\n\n"United States" : 7,\n\n};\n    $(function(){\n$(\'#world-map\').vectorMap({\n  map: \'world_mill_en\',\n  backgroundColor: \'#333333\',\n  zoomButtons : false,\n  series: {\n    regions: [{\n      values: gdpData,\n      scale: [\'#00CC00\', \'#008400\'],\n      normalizeFunction: \'polynomial\'\n    }]\n  },\n  onRegionTipShow: function(e, el, code){\n    if (typeof gdpData[code] !=="undefined"){\n    el.html(el.html()+\' <br>Hosts Found : \'+gdpData[code]);\n    } \n  }\n});\n    });\n  </script>\n\n\n\n<script type="text/javascript">\n            $(document).ready(function() {\n$(\'[data-toggle="tooltip"]\').tooltip({\'placement\': \'top\'});\n\n$("body").on(\'DOMSubtreeModified\', ".modal-content", function() {\n    $(".modal-heading").hide();\n    $(".modal-content").show();\n});\n\n      $(\'body\').on(\'hidden.bs.modal\', \'.modal\', function () {\n        $(this).removeData(\'bs.modal\');\n      });\n\n            }); //END $(document).ready()\n\n\n$(\'a.external\').on(\'click\', function(e) {\n        e.preventDefault();\n        $(".modal-heading").show();\n        $(".modal-content").hide();\n\n\n        var url = $(this).attr(\'href\');\n        $(".modal-body").html(\'<iframe id="myiframe" style="background-color: #ccc;" width="100%" height="100%" frameborder="0" scrolling="yes" allowtransparency="true" src="\'+url+\'"></iframe>\');\n    });\n\n \n\n\n    $(\'#myModal\').on(\'show.bs.modal\', function () {\n        $(this).find(\'.modal-dialog\').css({\n                  width:\'80%\', //choose your width\n                  height:\'80%\',\n                  \'padding\':\'5\'\n           });\n         $(this).find(\'.modal-content\').css({\n                  height:\'100%\',\n                  \'border-radius\':\'0\',\n                  \'padding\':\'15\'\n           });\n         $(this).find(\'.modal-body\').html(null);\n         $(this).find(\'.modal-body\').css({\n                  width:\'auto\',\n                  height:\'100%\',\n                  \'padding\':\'5\'\n           });\n    })\n\n        </script>\n\n<script>\n$(document).ready(function(){\n  $("#showloading").hide();\n  $("#formsubmit").click(function(){\n    $("#hideform").hide();\n    $("#showloading").show();\n  });\n\n});\n</script>\n<!-- Google tag (gtag.js) -->\n<script async src="https://www.googletagmanager.com/gtag/js?id=G-FPGN9YXFNE"></script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag(\'js\', new Date());\n\n  gtag(\'config\', \'G-FPGN9YXFNE\');\n</script>\n  </body>\n</html>\n',
        )

    def check(self, module_test, events):
        assert any(e.data == "asdf.blacklanternsecurity.com" for e in events), "Failed to detect subdomain"
