"""
This file contains a dictionary of the ABC checklist with each item's label,
regex pattern, new column name, and whether to look for opioids, negation, & previews.
"""

checklist = {
    "1a": {
        "lab": 'Since last visit: #1 "Patient used illicit drugs or evidences problem drinking" #1a Illicit drugs',
        "pat": r"((illicit drug)|mariju|cocai|heroin|polysubst|methamphetamine|amphetamine|\becstasy|(street drugs)|IVDU|(IV drug))",
        "col_name": "illicit_drugs",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "1b": {
        "lab": "#1b Problematic alcohol use",
        "pat": r"((problem)([^\.]{1,10})(drink|alcoh|etoh))|(((drink|alcoh|etoh))([^\.]{1,10})(abuse|addic|ism|dependence)(?![^\.]{1,10}(father|mother)))",
        "col_name": "problem_drinking",
        "opioid": False,
        "negation": True,
        "preview": False,
        "common_fp": ["mother", "sister", "father", "brother", "aunt", "uncle"],
    },
    "1c": {
        "lab": "1c. DUIs",
        "pat": r"(\bDUI\b)",
        "col_name": "dui",
        "opioid": False,
        "negation": True,
        "preview": False,
    },
    "2": {
        "lab": '#2 "Patient has hoarded meds"',
        "pat": r"(\bhoard|stash|(left over)|\bstoring|stockpil)",
        "col_name": "hoarding",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["hoarder"],
    },
    "3": {
        "lab": '#3 "Patient used more narcotic than prescribed"',
        "pat": r"((more+(?=.{1,50}than presc))|(ta?o?o?ke?i?n?g? extra(?![^\.]{1,10}strength)))",
        "col_name": "more_narcotic",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "4": {
        "lab": '#4 "Patient ran out of meds early"',
        "pat": r"(((running|ran) \bout\b(?=.{1,50}earl))|((\bout\b(?=.{1,50}earl)))|(too early to refill)|(refill early))",
        "col_name": "ran_out_early",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["out of bed"],
    },
    "5a": {
        "lab": '#5a "Patient has increased use of narcotics" 5a. Increased narcotic/opioid use',
        "pat": r"((increased|increasing) use)",
        "col_name": "increased_op",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "5b": {
        "lab": "#5b Dose escalation (alternative to increased use)",
        "pat": r"((escalate?d?i?o?n?(?=((.{1,10})dos)))|(dose?a?g?e?(?=((.{1,10})escalat))))",
        "col_name": "escalation_op",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "6": {
        "lab": '#6 "Patient used analgesics PRN when prescription is for time contingent use"',
        "pat": r"(not?n? ?-?adher)|(non?t?-? ?complian)",
        "col_name": "prn",
        "opioid": True,
        "negation": False,
        "preview": False,
        "common_fp": ["mepitel nonadherent dressing", "diet", "regimen"],
    },
    "7a": {
        "lab": '#7 "Patient received narcotics from more than one provider"',
        "pat": r"(more than one|multiple)(?=((.{1,50}(provider|doctor|pharmac|prescrib))))",
        "col_name": "multiple_sources_x",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["diagnoses"],
    },
    "7b": {
        "lab": 'Alternate "More than one provider" Search',
        "pat": r"(more than one|multiple)(?=((.{1,50}(provider|doctor|pharmac|prescrib))))",
        "col_name": "multiple_sources_y",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["diagnoses"],
    },
    "8": {
        "lab": '#8 "Patient bought meds on the streets"',  # alternate: r'((med|drug).{1,10}(on the street))|((on the street).{1,10}(med|drug))'
        "pat": r"(on the street)",
        "col_name": "bought_on_street",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "9": {
        "lab": '#9 "Patient appears sedated or confused (e.g., slurred speech, unresponsive)"',
        "pat": r"(sedated|confused|(slurred speech)|unresponsive)",
        "col_name": "sedated",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "10": {
        "lab": '#10 "Patient expresses worries about addiction"',
        "pat": r"(worr.{1,25}addic)",
        "col_name": "worries_about_addiction",
        "opioid": False,
        "negation": True,
        "preview": False,
    },
    "11a": {
        "lab": '#11 "Patient expressed a strong preference for a specific type of analgesic or a specific route of administration"',
        "pat": r"((patient|pt) (request|prefer|(preferr?s? to take)))",
        "col_name": "strong_preference",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["pharm"],
    },
    "11b": {
        "lab": "#11b Strong Preference, IV",
        "pat": "r((patient|pt) (request|prefer|(prefers to take))([^\.]{1,10}IV))",
        "col_name": "strong_preference_IV",
        "opioid": False,
        "negation": False,
        "preview": False,
    },
    "12a": {
        "lab": '#12a "Patient expresses concern about future availability of narcotic"',  # change take to tak and add opioid detection
        "pat": r"(((take)[^\.]{1,25})(away))",
        "col_name": "future_availability_1",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["disp", "rfl", "allerg"],
    },
    "12b": {
        "lab": "#12b Future Availability: Loss of medication",
        "pat": r"((((won|can)\'?t)[^\.]{1,25}(get))|(loss of medication))",
        "col_name": "future_availability_2",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "13": {
        "lab": '#13 "Patient reports worsened relationships with family"',
        "pat": r"(family (dynamics|problem))|(relationship problem)|((lost|(took))[^\.]{1,25}(kids|children|\bson|daughter))",
        "col_name": "worsened_relationships",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
    "14": {
        "lab": '#14 "Patient misrepresented analgesic prescription or use"',
        "pat": r"(misrepresent|(lied? about)|(\blying about))",
        "col_name": "misrep_use",
        "opioid": True,
        "negation": False,
        "preview": False,
    },
    "15": {
        "lab": '#15 "Patient indicated she or he ‘‘needs’’ or ‘‘must have’’ analgesic meds"',
        "pat": "((must have)|demands)",
        "col_name": "needs_must_have",
        "opioid": True,
        "negation": False,
        "preview": False,
        "common_fp": [r"[0-9]"],
    },
    "16": {
        "lab": '#16 "Discussion of analgesic meds was the predominant issue of visit"',
        "pat": r"(pain med)|opioid|opiod| narc|analges|suboxone|Avinza|codeine|dilaudid|fentanyl|hydrocodone|morphine|opana|opiate|oxycodone|oxycontin|oxymorphone|percocet|roxicodone|sufentanyl|vicodin|lortab|hydromorphone|abstral|actiq|alfentanil|arymo|ascomp|astramorph|avinza|belbuca|brompheniramine|bunavail|buprenex|buprenorphine|butalbital|butorphanol|butrans|capcof|carisoprodol|cheratussin|coditussin|conzip|demerol|dexbrompheniramine|dihydrocodeine|diskets|dolophine|durmorph|embeda|endacof|endocet|exalgo|fentora|fioricet|flowtuss|guaifenesin|histex|hycet|hycofenix|hydrocodone|hydromorphone|hysingla|ibudone|infumorph|iophen|iorinal|kadian|lazanda|levorphanol|lorcet|lotruss|meperidine|methadone|methadose|morphabond|morphine|ms contin|nalbuphine|nalocet|ninjacof|nucynta|obredon|opana|opium|orco|oxaydo|oxecta|oxycodone|panlor|paregoric|pentazocine|percocet|phenylhistine|primlev|pro-clear|probuphine|promethazine|psuedoephedrine|relcof|remifentanil|reprexain|rezira|robafen|roxicodone|rydex|suboxone|subsys|sufentanil|synalgos|talwin|tapentado|tramadol|trezix|triplidine|trymine|tusnel|tussicpas|ultiva|ultracet|ultram|verdrocet|vicodin|vicoprofen|virtussin|xartemix|xodol|xtampza|zamicet|zodryl|zubsolv|zutripro|zylon",
        "col_name": "opioid_tag",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["disp", "rfl", "allerg", "mg"],
    },
    "17": {
        "lab": '#17 "Patient exhibited lack of interest in rehab or self-management"',
        "pat": r"((not|no[^\.(need)]{1,25}(interest|seen|want|go))|resistant|dislike|refuse)([^\.]{1,25})(rehab|(pain management)|(pain clinic))",
        "col_name": "lack_interest_rehab",
        "opioid": True,
        "negation": False,
        "preview": False,
    },
    "18a": {
        "lab": '#18a "Patient reports minimal/inadequate relief from narcotic analgesic"',
        "pat": r"(not?\b|minimal|limited)([^\.]{1,25})(relief (from|with|w/t|))",
        "col_name": "minimal_relief_x",
        "opioid": True,
        "negation": False,
        "preview": False,
    },
    "18b": {
        "lab": "Patient reports minimal/inadequate relief: Tolerance",
        "pat": r"(\btoleran)",
        "col_name": "tolerance",
        "opioid": True,
        "negation": True,
        "preview": False,
        "common_fp": ["activity"],
    },
    "19": {
        "lab": '#19 "Patient indicated difficulty with using medication agreement"',
        "pat": r"((medication|med|opioi?d|narcotic) (agreement|contract) (breach|violat|problem|issue|fail))|((violat|problem|issue|fail|breach)[^\.]{1,25}(medication|med|opioi?d|narcotic) (agreement|contract))",
        "col_name": "med_agreement",
        "opioid": False,
        "negation": False,
        "preview": False,
    },
    "20": {
        "lab": '#20 (Other) "Significant others express concern over patient’s use of analgesics"',
        "pat": r"(wife|\bmother|father|husband|daughter|aunt|uncle|\bson|(significant other)|(family member))([^\.]{1,25})(concern|worr)",
        "col_name": "SO_concern",
        "opioid": True,
        "negation": True,
        "preview": False,
    },
}
