# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from ...core.unchecked_base_model import UncheckedBaseModel


class BatchWorkflowRunCreateResponse(UncheckedBaseModel):
    success: bool = pydantic.Field()
    """
    Indicates whether the batch request was successfully accepted and queued. `true` signifies success.
    """

    batch_id: typing_extensions.Annotated[str, FieldMetadata(alias="batchId")] = pydantic.Field()
    """
    A unique identifier for the submitted batch. This ID can be used to correlate the workflow runs created by this request. You can find this `batchId` associated with individual runs when listing workflow runs or in webhook payloads.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
