# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from .http_client import AsyncHttpClient, HttpClient


class BaseClientWrapper:
    def __init__(
        self,
        *,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        base_url: str,
        timeout: typing.Optional[float] = None,
        extend_api_version: typing.Optional[str] = None,
    ):
        self._token = token
        self._base_url = base_url
        self._timeout = timeout
        self._extend_api_version = extend_api_version

    def get_headers(self) -> typing.Dict[str, str]:
        headers: typing.Dict[str, str] = {
            "User-Agent": "extend_ai/0.0.12",
            "X-Fern-Language": "Python",
            "X-Fern-SDK-Name": "extend_ai",
            "X-Fern-SDK-Version": "0.0.12",
        }
        token = self._get_token()
        if token is not None:
            headers["Authorization"] = f"Bearer {token}"
        headers["x-extend-api-version"] = (
            self._extend_api_version if self._extend_api_version is not None else "2025-04-21"
        )
        return headers

    def _get_token(self) -> typing.Optional[str]:
        if isinstance(self._token, str) or self._token is None:
            return self._token
        else:
            return self._token()

    def get_base_url(self) -> str:
        return self._base_url

    def get_timeout(self) -> typing.Optional[float]:
        return self._timeout


class SyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        base_url: str,
        timeout: typing.Optional[float] = None,
        extend_api_version: typing.Optional[str] = None,
        httpx_client: httpx.Client,
    ):
        super().__init__(token=token, base_url=base_url, timeout=timeout, extend_api_version=extend_api_version)
        self.httpx_client = HttpClient(
            httpx_client=httpx_client,
            base_headers=self.get_headers,
            base_timeout=self.get_timeout,
            base_url=self.get_base_url,
        )


class AsyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = None,
        base_url: str,
        timeout: typing.Optional[float] = None,
        extend_api_version: typing.Optional[str] = None,
        httpx_client: httpx.AsyncClient,
    ):
        super().__init__(token=token, base_url=base_url, timeout=timeout, extend_api_version=extend_api_version)
        self.httpx_client = AsyncHttpClient(
            httpx_client=httpx_client,
            base_headers=self.get_headers,
            base_timeout=self.get_timeout,
            base_url=self.get_base_url,
        )
