# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.max_page_size import MaxPageSize
from ..types.next_page_token import NextPageToken
from ..types.provided_processor_output import ProvidedProcessorOutput
from ..types.sort_by_enum import SortByEnum
from ..types.sort_dir_enum import SortDirEnum
from .raw_client import AsyncRawEvaluationSetItemClient, RawEvaluationSetItemClient
from .types.evaluation_set_item_create_batch_request_items_item import EvaluationSetItemCreateBatchRequestItemsItem
from .types.evaluation_set_item_create_batch_response import EvaluationSetItemCreateBatchResponse
from .types.evaluation_set_item_create_response import EvaluationSetItemCreateResponse
from .types.evaluation_set_item_delete_response import EvaluationSetItemDeleteResponse
from .types.evaluation_set_item_list_response import EvaluationSetItemListResponse
from .types.evaluation_set_item_update_response import EvaluationSetItemUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class EvaluationSetItemClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEvaluationSetItemClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEvaluationSetItemClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEvaluationSetItemClient
        """
        return self._raw_client

    def list(
        self,
        id: str,
        *,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemListResponse:
        """
        List all items in a specific evaluation set. Evaluation set items are the individual files and expected outputs that are used to evaluate the performance of a given processor in Extend.

        This endpoint returns a paginated response. You can use the `nextPageToken` to fetch subsequent results.

        Parameters
        ----------
        id : str
            The ID of the evaluation set to retrieve items for.

            Example: `"ev_2LcgeY_mp2T5yPaEuq5Lw"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the evaluation set items by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the evaluation set items in ascending or descending order. Ascending order means the earliest evaluation set is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemListResponse
            Successfully retrieved evaluation set items

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.evaluation_set_item.list(id='evaluation_set_id_here', sort_by="updatedAt", sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        """
        _response = self._raw_client.list(
            id,
            sort_by=sort_by,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        evaluation_set_id: str,
        file_id: str,
        expected_output: ProvidedProcessorOutput,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemCreateResponse:
        """
        Evaluation set items are the individual files and expected outputs that are used to evaluate the performance of a given processor in Extend. This endpoint will create a new evaluation set item in Extend, which will be used during an evaluation run.

        Best Practices for Outputs in Evaluation Sets:
        - **Configure First, Output Later**
          - Always create and finalize your processor configuration before creating evaluation sets
          - Field IDs in outputs must match those defined in your processor configuration
        - **Type Consistency**
          - Ensure output types exactly match your processor configuration
          - For example, if a field is configured as "currency", don't submit a simple number value
        - **Field IDs**
          - Use the exact field IDs from your processor configuration
          - Create your own semantic IDs instead in the configs for each field/type instead of using the generated ones
        - **Value**
          - Remember that all results are inside the value key of a result object, except the values within nested structures.

        Parameters
        ----------
        evaluation_set_id : str
            The ID of the evaluation set to add the item to.

            Example: `"ev_Xj8mK2pL9nR4vT7qY5wZ"`

        file_id : str
            Extend's internal ID for the file. It will always start with "file_".

            Example: `"file_xK9mLPqRtN3vS8wF5hB2cQ"`

        expected_output : ProvidedProcessorOutput
            The expected output that will be used to evaluate the processor's performance.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemCreateResponse
            Successfully created evaluation set item

        Examples
        --------
        from extend_ai import Extend
        from extend_ai import ProvidedJsonOutput
        client = Extend(token="YOUR_TOKEN", )
        client.evaluation_set_item.create(evaluation_set_id='evaluation_set_id_here', file_id='file_id_here', expected_output=ProvidedJsonOutput(value={'key': 'value'
        }, ), )
        """
        _response = self._raw_client.create(
            evaluation_set_id=evaluation_set_id,
            file_id=file_id,
            expected_output=expected_output,
            request_options=request_options,
        )
        return _response.data

    def update(
        self,
        id: str,
        *,
        expected_output: ProvidedProcessorOutput,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemUpdateResponse:
        """
        If you need to change the expected output for a given evaluation set item, you can use this endpoint to update the item. This can be useful if you need to correct an error in the expected output or if the output of the processor has changed.

        Parameters
        ----------
        id : str
            The ID of the evaluation set item to update.

            Example: `"evi_kR9mNP12Qw4yTv8BdR3H"`

        expected_output : ProvidedProcessorOutput
            The expected output of the processor when run against the file

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemUpdateResponse
            Successfully updated evaluation set item

        Examples
        --------
        from extend_ai import Extend
        from extend_ai import ProvidedJsonOutput
        client = Extend(token="YOUR_TOKEN", )
        client.evaluation_set_item.update(id='evaluation_set_item_id_here', expected_output=ProvidedJsonOutput(value={'key': 'value'
        }, ), )
        """
        _response = self._raw_client.update(id, expected_output=expected_output, request_options=request_options)
        return _response.data

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EvaluationSetItemDeleteResponse:
        """
        Delete an evaluation set item from an evaluation set. This operation is permanent and cannot be undone.

        This endpoint can be used to remove individual items from an evaluation set when they are no longer needed or if they were added in error.

        Parameters
        ----------
        id : str
            The ID of the evaluation set item to delete.

            Example: `"evi_kR9mNP12Qw4yTv8BdR3H"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemDeleteResponse
            Successfully deleted evaluation set item

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.evaluation_set_item.delete(id='evaluation_set_item_id_here', )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def create_batch(
        self,
        *,
        evaluation_set_id: str,
        items: typing.Sequence[EvaluationSetItemCreateBatchRequestItemsItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemCreateBatchResponse:
        """
        If you have a large number of files that you need to add to an evaluation set, you can use this endpoint to create multiple evaluation set items at once. This can be useful if you have a large dataset that you need to evaluate the performance of a processor against.

        Note: you still need to create each File first using the file API.

        Parameters
        ----------
        evaluation_set_id : str
            The ID of the evaluation set to add the items to.

            Example: `"ev_2LcgeY_mp2T5yPaEuq5Lw"`

        items : typing.Sequence[EvaluationSetItemCreateBatchRequestItemsItem]
            An array of objects representing the evaluation set items to create

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemCreateBatchResponse
            Successfully created evaluation set items

        Examples
        --------
        from extend_ai import Extend
        from extend_ai.evaluation_set_item import EvaluationSetItemCreateBatchRequestItemsItem
        from extend_ai import ProvidedJsonOutput
        client = Extend(token="YOUR_TOKEN", )
        client.evaluation_set_item.create_batch(evaluation_set_id='evaluation_set_id_here', items=[EvaluationSetItemCreateBatchRequestItemsItem(file_id='file_id_here', expected_output=ProvidedJsonOutput(value={'key': 'value'
        }, ), )], )
        """
        _response = self._raw_client.create_batch(
            evaluation_set_id=evaluation_set_id, items=items, request_options=request_options
        )
        return _response.data


class AsyncEvaluationSetItemClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEvaluationSetItemClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEvaluationSetItemClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEvaluationSetItemClient
        """
        return self._raw_client

    async def list(
        self,
        id: str,
        *,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemListResponse:
        """
        List all items in a specific evaluation set. Evaluation set items are the individual files and expected outputs that are used to evaluate the performance of a given processor in Extend.

        This endpoint returns a paginated response. You can use the `nextPageToken` to fetch subsequent results.

        Parameters
        ----------
        id : str
            The ID of the evaluation set to retrieve items for.

            Example: `"ev_2LcgeY_mp2T5yPaEuq5Lw"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the evaluation set items by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the evaluation set items in ascending or descending order. Ascending order means the earliest evaluation set is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemListResponse
            Successfully retrieved evaluation set items

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.evaluation_set_item.list(id='evaluation_set_id_here', sort_by="updatedAt", sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            id,
            sort_by=sort_by,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        evaluation_set_id: str,
        file_id: str,
        expected_output: ProvidedProcessorOutput,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemCreateResponse:
        """
        Evaluation set items are the individual files and expected outputs that are used to evaluate the performance of a given processor in Extend. This endpoint will create a new evaluation set item in Extend, which will be used during an evaluation run.

        Best Practices for Outputs in Evaluation Sets:
        - **Configure First, Output Later**
          - Always create and finalize your processor configuration before creating evaluation sets
          - Field IDs in outputs must match those defined in your processor configuration
        - **Type Consistency**
          - Ensure output types exactly match your processor configuration
          - For example, if a field is configured as "currency", don't submit a simple number value
        - **Field IDs**
          - Use the exact field IDs from your processor configuration
          - Create your own semantic IDs instead in the configs for each field/type instead of using the generated ones
        - **Value**
          - Remember that all results are inside the value key of a result object, except the values within nested structures.

        Parameters
        ----------
        evaluation_set_id : str
            The ID of the evaluation set to add the item to.

            Example: `"ev_Xj8mK2pL9nR4vT7qY5wZ"`

        file_id : str
            Extend's internal ID for the file. It will always start with "file_".

            Example: `"file_xK9mLPqRtN3vS8wF5hB2cQ"`

        expected_output : ProvidedProcessorOutput
            The expected output that will be used to evaluate the processor's performance.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemCreateResponse
            Successfully created evaluation set item

        Examples
        --------
        from extend_ai import AsyncExtend
        from extend_ai import ProvidedJsonOutput
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.evaluation_set_item.create(evaluation_set_id='evaluation_set_id_here', file_id='file_id_here', expected_output=ProvidedJsonOutput(value={'key': 'value'
            }, ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            evaluation_set_id=evaluation_set_id,
            file_id=file_id,
            expected_output=expected_output,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self,
        id: str,
        *,
        expected_output: ProvidedProcessorOutput,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemUpdateResponse:
        """
        If you need to change the expected output for a given evaluation set item, you can use this endpoint to update the item. This can be useful if you need to correct an error in the expected output or if the output of the processor has changed.

        Parameters
        ----------
        id : str
            The ID of the evaluation set item to update.

            Example: `"evi_kR9mNP12Qw4yTv8BdR3H"`

        expected_output : ProvidedProcessorOutput
            The expected output of the processor when run against the file

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemUpdateResponse
            Successfully updated evaluation set item

        Examples
        --------
        from extend_ai import AsyncExtend
        from extend_ai import ProvidedJsonOutput
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.evaluation_set_item.update(id='evaluation_set_item_id_here', expected_output=ProvidedJsonOutput(value={'key': 'value'
            }, ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, expected_output=expected_output, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> EvaluationSetItemDeleteResponse:
        """
        Delete an evaluation set item from an evaluation set. This operation is permanent and cannot be undone.

        This endpoint can be used to remove individual items from an evaluation set when they are no longer needed or if they were added in error.

        Parameters
        ----------
        id : str
            The ID of the evaluation set item to delete.

            Example: `"evi_kR9mNP12Qw4yTv8BdR3H"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemDeleteResponse
            Successfully deleted evaluation set item

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.evaluation_set_item.delete(id='evaluation_set_item_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def create_batch(
        self,
        *,
        evaluation_set_id: str,
        items: typing.Sequence[EvaluationSetItemCreateBatchRequestItemsItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EvaluationSetItemCreateBatchResponse:
        """
        If you have a large number of files that you need to add to an evaluation set, you can use this endpoint to create multiple evaluation set items at once. This can be useful if you have a large dataset that you need to evaluate the performance of a processor against.

        Note: you still need to create each File first using the file API.

        Parameters
        ----------
        evaluation_set_id : str
            The ID of the evaluation set to add the items to.

            Example: `"ev_2LcgeY_mp2T5yPaEuq5Lw"`

        items : typing.Sequence[EvaluationSetItemCreateBatchRequestItemsItem]
            An array of objects representing the evaluation set items to create

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EvaluationSetItemCreateBatchResponse
            Successfully created evaluation set items

        Examples
        --------
        from extend_ai import AsyncExtend
        from extend_ai.evaluation_set_item import EvaluationSetItemCreateBatchRequestItemsItem
        from extend_ai import ProvidedJsonOutput
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.evaluation_set_item.create_batch(evaluation_set_id='evaluation_set_id_here', items=[EvaluationSetItemCreateBatchRequestItemsItem(file_id='file_id_here', expected_output=ProvidedJsonOutput(value={'key': 'value'
            }, ), )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_batch(
            evaluation_set_id=evaluation_set_id, items=items, request_options=request_options
        )
        return _response.data
