# This file was auto-generated by Fern from our API Definition.

import typing

from .. import core
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.max_page_size import MaxPageSize
from ..types.next_page_token import NextPageToken
from ..types.sort_dir_enum import SortDirEnum
from .raw_client import AsyncRawFileClient, RawFileClient
from .types.file_delete_response import FileDeleteResponse
from .types.file_get_response import FileGetResponse
from .types.file_list_response import FileListResponse
from .types.file_upload_response import FileUploadResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FileClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFileClient
        """
        return self._raw_client

    def list(
        self,
        *,
        name_contains: typing.Optional[str] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileListResponse:
        """
        List files in your account. Files represent documents that have been uploaded to Extend. This endpoint returns a paginated response. You can use the `nextPageToken` to fetch subsequent results.

        Parameters
        ----------
        name_contains : typing.Optional[str]
            Filters files to only include those that contain the given string in the name.

            Example: `"invoice"`

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the files in ascending or descending order. Ascending order means the earliest file is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileListResponse
            Successfully retrieved files

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.file.list(name_contains='nameContains', sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        """
        _response = self._raw_client.list(
            name_contains=name_contains,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        raw_text: typing.Optional[bool] = None,
        markdown: typing.Optional[bool] = None,
        html: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileGetResponse:
        """
        Fetch a file by its ID to obtain additional details and the raw file content.

        Parameters
        ----------
        id : str
            Extend's ID for the file. It will always start with `"file_"`. This ID is returned when creating a new File, or the value on the `fileId` field in a WorkflowRun.

            Example: `"file_Xj8mK2pL9nR4vT7qY5wZ"`

        raw_text : typing.Optional[bool]
            If set to true, the raw text content of the file will be included in the response. This is useful for indexing text-based files like PDFs, Word Documents, etc.

        markdown : typing.Optional[bool]
            If set to true, the markdown content of the file will be included in the response. This is useful for indexing very clean content into RAG pipelines for files like PDFs, Word Documents, etc.

            Only available for files with a type of PDF, IMG, or .doc/.docx files that were auto-converted to PDFs.

        html : typing.Optional[bool]
            If set to true, the html content of the file will be included in the response. This is useful for indexing html content into RAG pipelines.

            Only available for files with a type of DOCX.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileGetResponse
            Successfully retrieved file

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.file.get(id='file_id_here', raw_text=True, markdown=True, html=True, )
        """
        _response = self._raw_client.get(
            id, raw_text=raw_text, markdown=markdown, html=html, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FileDeleteResponse:
        """
        Delete a file and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the file to delete.

            Example: `"file_xK9mLPqRtN3vS8wF5hB2cQ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileDeleteResponse
            Successfully deleted file

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.file.delete(id='file_id_here', )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def upload(self, *, file: core.File, request_options: typing.Optional[RequestOptions] = None) -> FileUploadResponse:
        """
        Upload and create a new file in Extend.

        This endpoint accepts file contents and registers them as a File in Extend, which can be used for [running workflows](https://docs.extend.ai/2025-04-21/developers/api-reference/workflow-endpoints/run-workflow), [creating evaluation set items](https://docs.extend.ai/2025-04-21/developers/api-reference/evaluation-set-endpoints/bulk-create-evaluation-set-items), [parsing](https://docs.extend.ai/2025-04-21/developers/api-reference/parse-endpoints/parse-file), etc.

        If an uploaded file is detected as a Word or PowerPoint document, it will be automatically converted to a PDF.

        Supported file types can be found [here](/product/general/supported-file-types).

        This endpoint requires multipart form encoding. Most HTTP clients will handle this encoding automatically (see the examples).

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileUploadResponse
            Successfully uploaded file

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.file.upload()
        """
        _response = self._raw_client.upload(file=file, request_options=request_options)
        return _response.data


class AsyncFileClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFileClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFileClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFileClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        name_contains: typing.Optional[str] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileListResponse:
        """
        List files in your account. Files represent documents that have been uploaded to Extend. This endpoint returns a paginated response. You can use the `nextPageToken` to fetch subsequent results.

        Parameters
        ----------
        name_contains : typing.Optional[str]
            Filters files to only include those that contain the given string in the name.

            Example: `"invoice"`

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the files in ascending or descending order. Ascending order means the earliest file is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileListResponse
            Successfully retrieved files

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.file.list(name_contains='nameContains', sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            name_contains=name_contains,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        raw_text: typing.Optional[bool] = None,
        markdown: typing.Optional[bool] = None,
        html: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FileGetResponse:
        """
        Fetch a file by its ID to obtain additional details and the raw file content.

        Parameters
        ----------
        id : str
            Extend's ID for the file. It will always start with `"file_"`. This ID is returned when creating a new File, or the value on the `fileId` field in a WorkflowRun.

            Example: `"file_Xj8mK2pL9nR4vT7qY5wZ"`

        raw_text : typing.Optional[bool]
            If set to true, the raw text content of the file will be included in the response. This is useful for indexing text-based files like PDFs, Word Documents, etc.

        markdown : typing.Optional[bool]
            If set to true, the markdown content of the file will be included in the response. This is useful for indexing very clean content into RAG pipelines for files like PDFs, Word Documents, etc.

            Only available for files with a type of PDF, IMG, or .doc/.docx files that were auto-converted to PDFs.

        html : typing.Optional[bool]
            If set to true, the html content of the file will be included in the response. This is useful for indexing html content into RAG pipelines.

            Only available for files with a type of DOCX.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileGetResponse
            Successfully retrieved file

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.file.get(id='file_id_here', raw_text=True, markdown=True, html=True, )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            id, raw_text=raw_text, markdown=markdown, html=html, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> FileDeleteResponse:
        """
        Delete a file and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the file to delete.

            Example: `"file_xK9mLPqRtN3vS8wF5hB2cQ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileDeleteResponse
            Successfully deleted file

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.file.delete(id='file_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def upload(
        self, *, file: core.File, request_options: typing.Optional[RequestOptions] = None
    ) -> FileUploadResponse:
        """
        Upload and create a new file in Extend.

        This endpoint accepts file contents and registers them as a File in Extend, which can be used for [running workflows](https://docs.extend.ai/2025-04-21/developers/api-reference/workflow-endpoints/run-workflow), [creating evaluation set items](https://docs.extend.ai/2025-04-21/developers/api-reference/evaluation-set-endpoints/bulk-create-evaluation-set-items), [parsing](https://docs.extend.ai/2025-04-21/developers/api-reference/parse-endpoints/parse-file), etc.

        If an uploaded file is detected as a Word or PowerPoint document, it will be automatically converted to a PDF.

        Supported file types can be found [here](/product/general/supported-file-types).

        This endpoint requires multipart form encoding. Most HTTP clients will handle this encoding automatically (see the examples).

        Parameters
        ----------
        file : core.File
            See core.File for more documentation

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FileUploadResponse
            Successfully uploaded file

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.file.upload()
        asyncio.run(main())
        """
        _response = await self._raw_client.upload(file=file, request_options=request_options)
        return _response.data
