# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawParserRunClient, RawParserRunClient
from .types.parser_run_delete_response import ParserRunDeleteResponse
from .types.parser_run_get_request_response_type import ParserRunGetRequestResponseType
from .types.parser_run_get_response import ParserRunGetResponse


class ParserRunClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawParserRunClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawParserRunClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawParserRunClient
        """
        return self._raw_client

    def get(
        self,
        id: str,
        *,
        response_type: typing.Optional[ParserRunGetRequestResponseType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParserRunGetResponse:
        """
        Retrieve the status and results of a parser run.

        Use this endpoint to get results for a parser run that has already completed, or to check on the status of an asynchronous parser run initiated via the [Parse File Asynchronously](https://docs.extend.ai/2025-04-21/developers/api-reference/parse-endpoints/parse-file-async) endpoint.

        If parsing is still in progress, you'll receive a response with just the status. Once complete, you'll receive the full parsed content in the response.

        Parameters
        ----------
        id : str
            The unique identifier for the parser run.

            Example: `"parser_run_xK9mLPqRtN3vS8wF5hB2cQ"`

        response_type : typing.Optional[ParserRunGetRequestResponseType]
            Controls the format of the response chunks. Defaults to `json` if not specified.
            * `json` - Returns chunks with inline content
            * `url` - Returns chunks with presigned URLs to content instead of inline data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParserRunGetResponse
            Successfully retrieved parser run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.parser_run.get(id='parser_run_id_here', response_type="json", )
        """
        _response = self._raw_client.get(id, response_type=response_type, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ParserRunDeleteResponse:
        """
        Delete a parser run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the parser run to delete.

            Example: `"parser_run_xK9mLPqRtN3vS8wF5hB2cQ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParserRunDeleteResponse
            Successfully deleted parser run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.parser_run.delete(id='parser_run_id_here', )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data


class AsyncParserRunClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawParserRunClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawParserRunClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawParserRunClient
        """
        return self._raw_client

    async def get(
        self,
        id: str,
        *,
        response_type: typing.Optional[ParserRunGetRequestResponseType] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ParserRunGetResponse:
        """
        Retrieve the status and results of a parser run.

        Use this endpoint to get results for a parser run that has already completed, or to check on the status of an asynchronous parser run initiated via the [Parse File Asynchronously](https://docs.extend.ai/2025-04-21/developers/api-reference/parse-endpoints/parse-file-async) endpoint.

        If parsing is still in progress, you'll receive a response with just the status. Once complete, you'll receive the full parsed content in the response.

        Parameters
        ----------
        id : str
            The unique identifier for the parser run.

            Example: `"parser_run_xK9mLPqRtN3vS8wF5hB2cQ"`

        response_type : typing.Optional[ParserRunGetRequestResponseType]
            Controls the format of the response chunks. Defaults to `json` if not specified.
            * `json` - Returns chunks with inline content
            * `url` - Returns chunks with presigned URLs to content instead of inline data

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParserRunGetResponse
            Successfully retrieved parser run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.parser_run.get(id='parser_run_id_here', response_type="json", )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, response_type=response_type, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ParserRunDeleteResponse:
        """
        Delete a parser run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the parser run to delete.

            Example: `"parser_run_xK9mLPqRtN3vS8wF5hB2cQ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ParserRunDeleteResponse
            Successfully deleted parser run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.parser_run.delete(id='parser_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data
