# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.serialization import FieldMetadata
from ...core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from ...types.chunk import Chunk
from ...types.parse_config import ParseConfig
from ...types.parser_run_credits import ParserRunCredits
from ...types.parser_run_metrics import ParserRunMetrics
from ...types.parser_run_status_enum import ParserRunStatusEnum
from ...types.parser_run_status_status import ParserRunStatusStatus


class ParserRunGetResponseParserRun_ParserRunStatus(UncheckedBaseModel):
    object: typing.Literal["parser_run_status"] = "parser_run_status"
    id: str
    status: ParserRunStatusStatus
    failure_reason: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="failureReason")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class ParserRunGetResponseParserRun_ParserRun(UncheckedBaseModel):
    object: typing.Literal["parser_run"] = "parser_run"
    id: str
    file_id: typing_extensions.Annotated[str, FieldMetadata(alias="fileId")]
    chunks: typing.List[Chunk]
    status: ParserRunStatusEnum
    failure_reason: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="failureReason")] = None
    metrics: ParserRunMetrics
    config: ParseConfig
    usage: typing.Optional[ParserRunCredits] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


ParserRunGetResponseParserRun = typing_extensions.Annotated[
    typing.Union[ParserRunGetResponseParserRun_ParserRunStatus, ParserRunGetResponseParserRun_ParserRun],
    UnionMetadata(discriminant="object"),
]
