# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error import Error
from ..types.processor_type import ProcessorType
from .types.processor_create_request_config import ProcessorCreateRequestConfig
from .types.processor_create_response import ProcessorCreateResponse
from .types.processor_update_request_config import ProcessorUpdateRequestConfig
from .types.processor_update_response import ProcessorUpdateResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawProcessorClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        name: str,
        type: ProcessorType,
        clone_processor_id: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProcessorCreateResponse]:
        """
        Create a new processor in Extend, optionally cloning from an existing processor

        Parameters
        ----------
        name : str
            The name of the new processor

        type : ProcessorType

        clone_processor_id : typing.Optional[str]
            The ID of an existing processor to clone. One of `cloneProcessorId` or `config` must be provided.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        config : typing.Optional[ProcessorCreateRequestConfig]
            The configuration for the processor. The type of configuration must match the processor type. One of `cloneProcessorId` or `config` must be provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorCreateResponse]
            Successfully created processor
        """
        _response = self._client_wrapper.httpx_client.request(
            "processors",
            method="POST",
            json={
                "name": name,
                "type": type,
                "cloneProcessorId": clone_processor_id,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorCreateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorCreateResponse,
                    construct_type(
                        type_=ProcessorCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorUpdateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProcessorUpdateResponse]:
        """
        Update an existing processor in Extend

        Parameters
        ----------
        id : str
            The ID of the processor to update.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        name : typing.Optional[str]
            The new name for the processor

        config : typing.Optional[ProcessorUpdateRequestConfig]
            The new configuration for the processor. The type of configuration must match the processor type:
            * For classification processors, use `ClassificationConfig`
            * For extraction processors, use `ExtractionConfig`
            * For splitter processors, use `SplitterConfig`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorUpdateResponse]
            Successfully updated processor
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(id)}",
            method="POST",
            json={
                "name": name,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorUpdateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorUpdateResponse,
                    construct_type(
                        type_=ProcessorUpdateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawProcessorClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        name: str,
        type: ProcessorType,
        clone_processor_id: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProcessorCreateResponse]:
        """
        Create a new processor in Extend, optionally cloning from an existing processor

        Parameters
        ----------
        name : str
            The name of the new processor

        type : ProcessorType

        clone_processor_id : typing.Optional[str]
            The ID of an existing processor to clone. One of `cloneProcessorId` or `config` must be provided.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        config : typing.Optional[ProcessorCreateRequestConfig]
            The configuration for the processor. The type of configuration must match the processor type. One of `cloneProcessorId` or `config` must be provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorCreateResponse]
            Successfully created processor
        """
        _response = await self._client_wrapper.httpx_client.request(
            "processors",
            method="POST",
            json={
                "name": name,
                "type": type,
                "cloneProcessorId": clone_processor_id,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorCreateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorCreateResponse,
                    construct_type(
                        type_=ProcessorCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorUpdateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProcessorUpdateResponse]:
        """
        Update an existing processor in Extend

        Parameters
        ----------
        id : str
            The ID of the processor to update.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        name : typing.Optional[str]
            The new name for the processor

        config : typing.Optional[ProcessorUpdateRequestConfig]
            The new configuration for the processor. The type of configuration must match the processor type:
            * For classification processors, use `ClassificationConfig`
            * For extraction processors, use `ExtractionConfig`
            * For splitter processors, use `SplitterConfig`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorUpdateResponse]
            Successfully updated processor
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(id)}",
            method="POST",
            json={
                "name": name,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorUpdateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorUpdateResponse,
                    construct_type(
                        type_=ProcessorUpdateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
