# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.json_object import JsonObject
from ..types.max_page_size import MaxPageSize
from ..types.next_page_token import NextPageToken
from ..types.processor_id import ProcessorId
from ..types.processor_run_file_input import ProcessorRunFileInput
from ..types.processor_status import ProcessorStatus
from ..types.processor_type import ProcessorType
from ..types.sort_by_enum import SortByEnum
from ..types.sort_dir_enum import SortDirEnum
from .raw_client import AsyncRawProcessorRunClient, RawProcessorRunClient
from .types.processor_run_cancel_response import ProcessorRunCancelResponse
from .types.processor_run_create_request_config import ProcessorRunCreateRequestConfig
from .types.processor_run_create_response import ProcessorRunCreateResponse
from .types.processor_run_delete_response import ProcessorRunDeleteResponse
from .types.processor_run_get_response import ProcessorRunGetResponse
from .types.processor_run_list_request_source import ProcessorRunListRequestSource
from .types.processor_run_list_response import ProcessorRunListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProcessorRunClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProcessorRunClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProcessorRunClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProcessorRunClient
        """
        return self._raw_client

    def list(
        self,
        *,
        status: typing.Optional[ProcessorStatus] = None,
        processor_id: typing.Optional[str] = None,
        processor_type: typing.Optional[ProcessorType] = None,
        source_id: typing.Optional[str] = None,
        source: typing.Optional[ProcessorRunListRequestSource] = None,
        file_name_contains: typing.Optional[str] = None,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessorRunListResponse:
        """
        List runs of a Processor. A ProcessorRun represents a single execution of a processor against a file.

        Parameters
        ----------
        status : typing.Optional[ProcessorStatus]
            Filters processor runs by their status. If not provided, no filter is applied.

             The status of a processor run:
             * `"PENDING"` - The processor run has not started yet
             * `"PROCESSING"` - The processor run is in progress
             * `"PROCESSED"` - The processor run completed successfully
             * `"FAILED"` - The processor run encountered an error
             * `"CANCELLED"` - The processor run was cancelled

        processor_id : typing.Optional[str]
            Filters processor runs by the processor ID. If not provided, runs for all processors are returned.

            Example: `"dp_BMdfq_yWM3sT-ZzvCnA3f"`

        processor_type : typing.Optional[ProcessorType]
            Filters processor runs by the processor type. If not provided, runs for all processor types are returned.

            Example: `"EXTRACT"`

        source_id : typing.Optional[str]
            Filters processor runs by the source ID. The source ID corresponds to the entity that created the processor run.

            Example: `"workflow_run_123"`

        source : typing.Optional[ProcessorRunListRequestSource]
            Filters processor runs by the source that created them. If not provided, runs from all sources are returned.

            The source of the processor run:
            * `"ADMIN"` - Created by admin
            * `"BATCH_PROCESSOR_RUN"` - Created from a batch processor run
            * `"PLAYGROUND"` - Created from playground
            * `"WORKFLOW_CONFIGURATION"` - Created from workflow configuration
            * `"WORKFLOW_RUN"` - Created from a workflow run
            * `"STUDIO"` - Created from Studio
            * `"API"` - Created via API

        file_name_contains : typing.Optional[str]
            Filters processor runs by the name of the file. Only returns processor runs where the file name contains this string.

            Example: `"invoice"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the processor runs by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the processor runs in ascending or descending order. Ascending order means the earliest processor run is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunListResponse
            You will get a list of summaries for each processor run. These are shortened versions of the full ProcessorRun object.

            To get the full object, use the [Get ProcessorRun](/developers/api-reference/processor-endpoints/get-processor-run) endpoint.

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_run.list(status="PENDING", processor_id='processorId', processor_type="EXTRACT", source_id='sourceId', source="ADMIN", file_name_contains='fileNameContains', sort_by="updatedAt", sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        """
        _response = self._raw_client.list(
            status=status,
            processor_id=processor_id,
            processor_type=processor_type,
            source_id=source_id,
            source=source,
            file_name_contains=file_name_contains,
            sort_by=sort_by,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        processor_id: ProcessorId,
        version: typing.Optional[str] = OMIT,
        file: typing.Optional[ProcessorRunFileInput] = OMIT,
        raw_text: typing.Optional[str] = OMIT,
        sync: typing.Optional[bool] = OMIT,
        priority: typing.Optional[int] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        config: typing.Optional[ProcessorRunCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessorRunCreateResponse:
        """
        Run processors (extraction, classification, splitting, etc.) on a given document.

        **Synchronous vs Asynchronous Processing:**
        - **Asynchronous (default)**: Returns immediately with `PROCESSING` status. Use webhooks or polling to get results.
        - **Synchronous**: Set `sync: true` to wait for completion and get final results in the response (5-minute timeout).

        **For asynchronous processing:**
        - You can [configure webhooks](https://docs.extend.ai/2025-04-21/developers/webhooks/configuration) to receive notifications when a processor run is complete or failed.
        - Or you can [poll the get endpoint](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/get-processor-run) for updates on the status of the processor run.

        Parameters
        ----------
        processor_id : ProcessorId

        version : typing.Optional[str]
            An optional version of the processor to use. When not supplied, the most recent published version of the processor will be used. Special values include:
            - `"latest"` for the most recent published version. If there are no published versions, the draft version will be used.
            - `"draft"` for the draft version.
            - Specific version numbers corresponding to versions your team has published, e.g. `"1.0"`, `"2.2"`, etc.

        file : typing.Optional[ProcessorRunFileInput]
            The file to be processed. One of `file` or `rawText` must be provided. Supported file types can be found [here](/product/general/supported-file-types).

        raw_text : typing.Optional[str]
            A raw string to be processed. Can be used in place of file when passing raw text data streams. One of `file` or `rawText` must be provided.

        sync : typing.Optional[bool]
            Whether to run the processor synchronously. When `true`, the request will wait for the processor run to complete and return the final results. When `false` (default), the request returns immediately with a `PROCESSING` status, and you can poll for completion or use webhooks. For production use cases, we recommending leaving sync off and building around an async integration for more resiliency, unless your use case is predictably fast (e.g. sub < 30 seconds) run time or otherwise have integration constraints that require a synchronous API.

            **Timeout**: Synchronous requests have a 5-minute timeout. If the processor run takes longer, it will continue processing asynchronously and you can retrieve the results via the GET endpoint.

        priority : typing.Optional[int]
            An optional value used to determine the relative order of ProcessorRuns when rate limiting is in effect. Lower values will be prioritized before higher values.

        metadata : typing.Optional[JsonObject]
            An optional object that can be passed in to identify the run of the document processor. It will be returned back to you in the response and webhooks.

        config : typing.Optional[ProcessorRunCreateRequestConfig]
            The configuration for the processor run. If this is provided, this config will be used. If not provided, the config for the specific version you provide will be used. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunCreateResponse
            Successfully created processor run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_run.create(processor_id='processor_id_here', )
        """
        _response = self._raw_client.create(
            processor_id=processor_id,
            version=version,
            file=file,
            raw_text=raw_text,
            sync=sync,
            priority=priority,
            metadata=metadata,
            config=config,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProcessorRunGetResponse:
        """
        Retrieve details about a specific processor run, including its status, outputs, and any edits made during review.

        A common use case for this endpoint is to poll for the status and final output of an async processor run when using the [Run Processor](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/run-processor) endpoint. For instance, if you do not want to not configure webhooks to receive the output via completion/failure events.

        Parameters
        ----------
        id : str
            The unique identifier for this processor run.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunGetResponse
            Successfully retrieved processor run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_run.get(id='processor_run_id_here', )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProcessorRunDeleteResponse:
        """
        Delete a processor run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the processor run to delete.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunDeleteResponse
            Successfully deleted processor run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_run.delete(id='processor_run_id_here', )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def cancel(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProcessorRunCancelResponse:
        """
        Cancel a running processor run by its ID. This endpoint allows you to stop a processor run that is currently in progress.

        Note: Only processor runs with a status of `"PROCESSING"` can be cancelled. Processor runs that have already completed, failed, or been cancelled cannot be cancelled again.

        Parameters
        ----------
        id : str
            The unique identifier for the processor run to cancel.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunCancelResponse
            Successfully cancelled processor run

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_run.cancel(id='processor_run_id_here', )
        """
        _response = self._raw_client.cancel(id, request_options=request_options)
        return _response.data


class AsyncProcessorRunClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProcessorRunClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProcessorRunClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProcessorRunClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        status: typing.Optional[ProcessorStatus] = None,
        processor_id: typing.Optional[str] = None,
        processor_type: typing.Optional[ProcessorType] = None,
        source_id: typing.Optional[str] = None,
        source: typing.Optional[ProcessorRunListRequestSource] = None,
        file_name_contains: typing.Optional[str] = None,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessorRunListResponse:
        """
        List runs of a Processor. A ProcessorRun represents a single execution of a processor against a file.

        Parameters
        ----------
        status : typing.Optional[ProcessorStatus]
            Filters processor runs by their status. If not provided, no filter is applied.

             The status of a processor run:
             * `"PENDING"` - The processor run has not started yet
             * `"PROCESSING"` - The processor run is in progress
             * `"PROCESSED"` - The processor run completed successfully
             * `"FAILED"` - The processor run encountered an error
             * `"CANCELLED"` - The processor run was cancelled

        processor_id : typing.Optional[str]
            Filters processor runs by the processor ID. If not provided, runs for all processors are returned.

            Example: `"dp_BMdfq_yWM3sT-ZzvCnA3f"`

        processor_type : typing.Optional[ProcessorType]
            Filters processor runs by the processor type. If not provided, runs for all processor types are returned.

            Example: `"EXTRACT"`

        source_id : typing.Optional[str]
            Filters processor runs by the source ID. The source ID corresponds to the entity that created the processor run.

            Example: `"workflow_run_123"`

        source : typing.Optional[ProcessorRunListRequestSource]
            Filters processor runs by the source that created them. If not provided, runs from all sources are returned.

            The source of the processor run:
            * `"ADMIN"` - Created by admin
            * `"BATCH_PROCESSOR_RUN"` - Created from a batch processor run
            * `"PLAYGROUND"` - Created from playground
            * `"WORKFLOW_CONFIGURATION"` - Created from workflow configuration
            * `"WORKFLOW_RUN"` - Created from a workflow run
            * `"STUDIO"` - Created from Studio
            * `"API"` - Created via API

        file_name_contains : typing.Optional[str]
            Filters processor runs by the name of the file. Only returns processor runs where the file name contains this string.

            Example: `"invoice"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the processor runs by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the processor runs in ascending or descending order. Ascending order means the earliest processor run is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunListResponse
            You will get a list of summaries for each processor run. These are shortened versions of the full ProcessorRun object.

            To get the full object, use the [Get ProcessorRun](/developers/api-reference/processor-endpoints/get-processor-run) endpoint.

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_run.list(status="PENDING", processor_id='processorId', processor_type="EXTRACT", source_id='sourceId', source="ADMIN", file_name_contains='fileNameContains', sort_by="updatedAt", sort_dir="asc", next_page_token='xK9mLPqRtN3vS8wF5hB2cQ==:zWvUxYjM4nKpL7aDgE9HbTcR2mAyX3/Q+CNkfBSw1dZ=', max_page_size=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            status=status,
            processor_id=processor_id,
            processor_type=processor_type,
            source_id=source_id,
            source=source,
            file_name_contains=file_name_contains,
            sort_by=sort_by,
            sort_dir=sort_dir,
            next_page_token=next_page_token,
            max_page_size=max_page_size,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        processor_id: ProcessorId,
        version: typing.Optional[str] = OMIT,
        file: typing.Optional[ProcessorRunFileInput] = OMIT,
        raw_text: typing.Optional[str] = OMIT,
        sync: typing.Optional[bool] = OMIT,
        priority: typing.Optional[int] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        config: typing.Optional[ProcessorRunCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessorRunCreateResponse:
        """
        Run processors (extraction, classification, splitting, etc.) on a given document.

        **Synchronous vs Asynchronous Processing:**
        - **Asynchronous (default)**: Returns immediately with `PROCESSING` status. Use webhooks or polling to get results.
        - **Synchronous**: Set `sync: true` to wait for completion and get final results in the response (5-minute timeout).

        **For asynchronous processing:**
        - You can [configure webhooks](https://docs.extend.ai/2025-04-21/developers/webhooks/configuration) to receive notifications when a processor run is complete or failed.
        - Or you can [poll the get endpoint](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/get-processor-run) for updates on the status of the processor run.

        Parameters
        ----------
        processor_id : ProcessorId

        version : typing.Optional[str]
            An optional version of the processor to use. When not supplied, the most recent published version of the processor will be used. Special values include:
            - `"latest"` for the most recent published version. If there are no published versions, the draft version will be used.
            - `"draft"` for the draft version.
            - Specific version numbers corresponding to versions your team has published, e.g. `"1.0"`, `"2.2"`, etc.

        file : typing.Optional[ProcessorRunFileInput]
            The file to be processed. One of `file` or `rawText` must be provided. Supported file types can be found [here](/product/general/supported-file-types).

        raw_text : typing.Optional[str]
            A raw string to be processed. Can be used in place of file when passing raw text data streams. One of `file` or `rawText` must be provided.

        sync : typing.Optional[bool]
            Whether to run the processor synchronously. When `true`, the request will wait for the processor run to complete and return the final results. When `false` (default), the request returns immediately with a `PROCESSING` status, and you can poll for completion or use webhooks. For production use cases, we recommending leaving sync off and building around an async integration for more resiliency, unless your use case is predictably fast (e.g. sub < 30 seconds) run time or otherwise have integration constraints that require a synchronous API.

            **Timeout**: Synchronous requests have a 5-minute timeout. If the processor run takes longer, it will continue processing asynchronously and you can retrieve the results via the GET endpoint.

        priority : typing.Optional[int]
            An optional value used to determine the relative order of ProcessorRuns when rate limiting is in effect. Lower values will be prioritized before higher values.

        metadata : typing.Optional[JsonObject]
            An optional object that can be passed in to identify the run of the document processor. It will be returned back to you in the response and webhooks.

        config : typing.Optional[ProcessorRunCreateRequestConfig]
            The configuration for the processor run. If this is provided, this config will be used. If not provided, the config for the specific version you provide will be used. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunCreateResponse
            Successfully created processor run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_run.create(processor_id='processor_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            processor_id=processor_id,
            version=version,
            file=file,
            raw_text=raw_text,
            sync=sync,
            priority=priority,
            metadata=metadata,
            config=config,
            request_options=request_options,
        )
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProcessorRunGetResponse:
        """
        Retrieve details about a specific processor run, including its status, outputs, and any edits made during review.

        A common use case for this endpoint is to poll for the status and final output of an async processor run when using the [Run Processor](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/run-processor) endpoint. For instance, if you do not want to not configure webhooks to receive the output via completion/failure events.

        Parameters
        ----------
        id : str
            The unique identifier for this processor run.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunGetResponse
            Successfully retrieved processor run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_run.get(id='processor_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessorRunDeleteResponse:
        """
        Delete a processor run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the processor run to delete.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunDeleteResponse
            Successfully deleted processor run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_run.delete(id='processor_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def cancel(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessorRunCancelResponse:
        """
        Cancel a running processor run by its ID. This endpoint allows you to stop a processor run that is currently in progress.

        Note: Only processor runs with a status of `"PROCESSING"` can be cancelled. Processor runs that have already completed, failed, or been cancelled cannot be cancelled again.

        Parameters
        ----------
        id : str
            The unique identifier for the processor run to cancel.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorRunCancelResponse
            Successfully cancelled processor run

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_run.cancel(id='processor_run_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel(id, request_options=request_options)
        return _response.data
