# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error import Error
from ..types.extend_error import ExtendError
from ..types.json_object import JsonObject
from ..types.max_page_size import MaxPageSize
from ..types.next_page_token import NextPageToken
from ..types.processor_id import ProcessorId
from ..types.processor_run_file_input import ProcessorRunFileInput
from ..types.processor_status import ProcessorStatus
from ..types.processor_type import ProcessorType
from ..types.sort_by_enum import SortByEnum
from ..types.sort_dir_enum import SortDirEnum
from ..types.too_many_requests_error_body import TooManyRequestsErrorBody
from .types.processor_run_cancel_response import ProcessorRunCancelResponse
from .types.processor_run_create_request_config import ProcessorRunCreateRequestConfig
from .types.processor_run_create_response import ProcessorRunCreateResponse
from .types.processor_run_delete_response import ProcessorRunDeleteResponse
from .types.processor_run_get_response import ProcessorRunGetResponse
from .types.processor_run_list_request_source import ProcessorRunListRequestSource
from .types.processor_run_list_response import ProcessorRunListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawProcessorRunClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        status: typing.Optional[ProcessorStatus] = None,
        processor_id: typing.Optional[str] = None,
        processor_type: typing.Optional[ProcessorType] = None,
        source_id: typing.Optional[str] = None,
        source: typing.Optional[ProcessorRunListRequestSource] = None,
        file_name_contains: typing.Optional[str] = None,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProcessorRunListResponse]:
        """
        List runs of a Processor. A ProcessorRun represents a single execution of a processor against a file.

        Parameters
        ----------
        status : typing.Optional[ProcessorStatus]
            Filters processor runs by their status. If not provided, no filter is applied.

             The status of a processor run:
             * `"PENDING"` - The processor run has not started yet
             * `"PROCESSING"` - The processor run is in progress
             * `"PROCESSED"` - The processor run completed successfully
             * `"FAILED"` - The processor run encountered an error
             * `"CANCELLED"` - The processor run was cancelled

        processor_id : typing.Optional[str]
            Filters processor runs by the processor ID. If not provided, runs for all processors are returned.

            Example: `"dp_BMdfq_yWM3sT-ZzvCnA3f"`

        processor_type : typing.Optional[ProcessorType]
            Filters processor runs by the processor type. If not provided, runs for all processor types are returned.

            Example: `"EXTRACT"`

        source_id : typing.Optional[str]
            Filters processor runs by the source ID. The source ID corresponds to the entity that created the processor run.

            Example: `"workflow_run_123"`

        source : typing.Optional[ProcessorRunListRequestSource]
            Filters processor runs by the source that created them. If not provided, runs from all sources are returned.

            The source of the processor run:
            * `"ADMIN"` - Created by admin
            * `"BATCH_PROCESSOR_RUN"` - Created from a batch processor run
            * `"PLAYGROUND"` - Created from playground
            * `"WORKFLOW_CONFIGURATION"` - Created from workflow configuration
            * `"WORKFLOW_RUN"` - Created from a workflow run
            * `"STUDIO"` - Created from Studio
            * `"API"` - Created via API

        file_name_contains : typing.Optional[str]
            Filters processor runs by the name of the file. Only returns processor runs where the file name contains this string.

            Example: `"invoice"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the processor runs by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the processor runs in ascending or descending order. Ascending order means the earliest processor run is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorRunListResponse]
            You will get a list of summaries for each processor run. These are shortened versions of the full ProcessorRun object.

            To get the full object, use the [Get ProcessorRun](/developers/api-reference/processor-endpoints/get-processor-run) endpoint.
        """
        _response = self._client_wrapper.httpx_client.request(
            "processor_runs",
            method="GET",
            params={
                "status": status,
                "processorId": processor_id,
                "processorType": processor_type,
                "sourceId": source_id,
                "source": source,
                "fileNameContains": file_name_contains,
                "sortBy": sort_by,
                "sortDir": sort_dir,
                "nextPageToken": next_page_token,
                "maxPageSize": max_page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunListResponse,
                    construct_type(
                        type_=ProcessorRunListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        processor_id: ProcessorId,
        version: typing.Optional[str] = OMIT,
        file: typing.Optional[ProcessorRunFileInput] = OMIT,
        raw_text: typing.Optional[str] = OMIT,
        sync: typing.Optional[bool] = OMIT,
        priority: typing.Optional[int] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        config: typing.Optional[ProcessorRunCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProcessorRunCreateResponse]:
        """
        Run processors (extraction, classification, splitting, etc.) on a given document.

        **Synchronous vs Asynchronous Processing:**
        - **Asynchronous (default)**: Returns immediately with `PROCESSING` status. Use webhooks or polling to get results.
        - **Synchronous**: Set `sync: true` to wait for completion and get final results in the response (5-minute timeout).

        **For asynchronous processing:**
        - You can [configure webhooks](https://docs.extend.ai/2025-04-21/developers/webhooks/configuration) to receive notifications when a processor run is complete or failed.
        - Or you can [poll the get endpoint](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/get-processor-run) for updates on the status of the processor run.

        Parameters
        ----------
        processor_id : ProcessorId

        version : typing.Optional[str]
            An optional version of the processor to use. When not supplied, the most recent published version of the processor will be used. Special values include:
            - `"latest"` for the most recent published version. If there are no published versions, the draft version will be used.
            - `"draft"` for the draft version.
            - Specific version numbers corresponding to versions your team has published, e.g. `"1.0"`, `"2.2"`, etc.

        file : typing.Optional[ProcessorRunFileInput]
            The file to be processed. One of `file` or `rawText` must be provided. Supported file types can be found [here](/product/general/supported-file-types).

        raw_text : typing.Optional[str]
            A raw string to be processed. Can be used in place of file when passing raw text data streams. One of `file` or `rawText` must be provided.

        sync : typing.Optional[bool]
            Whether to run the processor synchronously. When `true`, the request will wait for the processor run to complete and return the final results. When `false` (default), the request returns immediately with a `PROCESSING` status, and you can poll for completion or use webhooks. For production use cases, we recommending leaving sync off and building around an async integration for more resiliency, unless your use case is predictably fast (e.g. sub < 30 seconds) run time or otherwise have integration constraints that require a synchronous API.

            **Timeout**: Synchronous requests have a 5-minute timeout. If the processor run takes longer, it will continue processing asynchronously and you can retrieve the results via the GET endpoint.

        priority : typing.Optional[int]
            An optional value used to determine the relative order of ProcessorRuns when rate limiting is in effect. Lower values will be prioritized before higher values.

        metadata : typing.Optional[JsonObject]
            An optional object that can be passed in to identify the run of the document processor. It will be returned back to you in the response and webhooks.

        config : typing.Optional[ProcessorRunCreateRequestConfig]
            The configuration for the processor run. If this is provided, this config will be used. If not provided, the config for the specific version you provide will be used. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorRunCreateResponse]
            Successfully created processor run
        """
        _response = self._client_wrapper.httpx_client.request(
            "processor_runs",
            method="POST",
            json={
                "processorId": processor_id,
                "version": version,
                "file": convert_and_respect_annotation_metadata(
                    object_=file, annotation=ProcessorRunFileInput, direction="write"
                ),
                "rawText": raw_text,
                "sync": sync,
                "priority": priority,
                "metadata": metadata,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorRunCreateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunCreateResponse,
                    construct_type(
                        type_=ProcessorRunCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        TooManyRequestsErrorBody,
                        construct_type(
                            type_=TooManyRequestsErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProcessorRunGetResponse]:
        """
        Retrieve details about a specific processor run, including its status, outputs, and any edits made during review.

        A common use case for this endpoint is to poll for the status and final output of an async processor run when using the [Run Processor](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/run-processor) endpoint. For instance, if you do not want to not configure webhooks to receive the output via completion/failure events.

        Parameters
        ----------
        id : str
            The unique identifier for this processor run.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorRunGetResponse]
            Successfully retrieved processor run
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processor_runs/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunGetResponse,
                    construct_type(
                        type_=ProcessorRunGetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProcessorRunDeleteResponse]:
        """
        Delete a processor run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the processor run to delete.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorRunDeleteResponse]
            Successfully deleted processor run
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processor_runs/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunDeleteResponse,
                    construct_type(
                        type_=ProcessorRunDeleteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ExtendError,
                        construct_type(
                            type_=ExtendError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cancel(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProcessorRunCancelResponse]:
        """
        Cancel a running processor run by its ID. This endpoint allows you to stop a processor run that is currently in progress.

        Note: Only processor runs with a status of `"PROCESSING"` can be cancelled. Processor runs that have already completed, failed, or been cancelled cannot be cancelled again.

        Parameters
        ----------
        id : str
            The unique identifier for the processor run to cancel.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorRunCancelResponse]
            Successfully cancelled processor run
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processor_runs/{jsonable_encoder(id)}/cancel",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunCancelResponse,
                    construct_type(
                        type_=ProcessorRunCancelResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawProcessorRunClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        status: typing.Optional[ProcessorStatus] = None,
        processor_id: typing.Optional[str] = None,
        processor_type: typing.Optional[ProcessorType] = None,
        source_id: typing.Optional[str] = None,
        source: typing.Optional[ProcessorRunListRequestSource] = None,
        file_name_contains: typing.Optional[str] = None,
        sort_by: typing.Optional[SortByEnum] = None,
        sort_dir: typing.Optional[SortDirEnum] = None,
        next_page_token: typing.Optional[NextPageToken] = None,
        max_page_size: typing.Optional[MaxPageSize] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProcessorRunListResponse]:
        """
        List runs of a Processor. A ProcessorRun represents a single execution of a processor against a file.

        Parameters
        ----------
        status : typing.Optional[ProcessorStatus]
            Filters processor runs by their status. If not provided, no filter is applied.

             The status of a processor run:
             * `"PENDING"` - The processor run has not started yet
             * `"PROCESSING"` - The processor run is in progress
             * `"PROCESSED"` - The processor run completed successfully
             * `"FAILED"` - The processor run encountered an error
             * `"CANCELLED"` - The processor run was cancelled

        processor_id : typing.Optional[str]
            Filters processor runs by the processor ID. If not provided, runs for all processors are returned.

            Example: `"dp_BMdfq_yWM3sT-ZzvCnA3f"`

        processor_type : typing.Optional[ProcessorType]
            Filters processor runs by the processor type. If not provided, runs for all processor types are returned.

            Example: `"EXTRACT"`

        source_id : typing.Optional[str]
            Filters processor runs by the source ID. The source ID corresponds to the entity that created the processor run.

            Example: `"workflow_run_123"`

        source : typing.Optional[ProcessorRunListRequestSource]
            Filters processor runs by the source that created them. If not provided, runs from all sources are returned.

            The source of the processor run:
            * `"ADMIN"` - Created by admin
            * `"BATCH_PROCESSOR_RUN"` - Created from a batch processor run
            * `"PLAYGROUND"` - Created from playground
            * `"WORKFLOW_CONFIGURATION"` - Created from workflow configuration
            * `"WORKFLOW_RUN"` - Created from a workflow run
            * `"STUDIO"` - Created from Studio
            * `"API"` - Created via API

        file_name_contains : typing.Optional[str]
            Filters processor runs by the name of the file. Only returns processor runs where the file name contains this string.

            Example: `"invoice"`

        sort_by : typing.Optional[SortByEnum]
            Sorts the processor runs by the given field.

        sort_dir : typing.Optional[SortDirEnum]
            Sorts the processor runs in ascending or descending order. Ascending order means the earliest processor run is returned first.

        next_page_token : typing.Optional[NextPageToken]

        max_page_size : typing.Optional[MaxPageSize]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorRunListResponse]
            You will get a list of summaries for each processor run. These are shortened versions of the full ProcessorRun object.

            To get the full object, use the [Get ProcessorRun](/developers/api-reference/processor-endpoints/get-processor-run) endpoint.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "processor_runs",
            method="GET",
            params={
                "status": status,
                "processorId": processor_id,
                "processorType": processor_type,
                "sourceId": source_id,
                "source": source,
                "fileNameContains": file_name_contains,
                "sortBy": sort_by,
                "sortDir": sort_dir,
                "nextPageToken": next_page_token,
                "maxPageSize": max_page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunListResponse,
                    construct_type(
                        type_=ProcessorRunListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        processor_id: ProcessorId,
        version: typing.Optional[str] = OMIT,
        file: typing.Optional[ProcessorRunFileInput] = OMIT,
        raw_text: typing.Optional[str] = OMIT,
        sync: typing.Optional[bool] = OMIT,
        priority: typing.Optional[int] = OMIT,
        metadata: typing.Optional[JsonObject] = OMIT,
        config: typing.Optional[ProcessorRunCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProcessorRunCreateResponse]:
        """
        Run processors (extraction, classification, splitting, etc.) on a given document.

        **Synchronous vs Asynchronous Processing:**
        - **Asynchronous (default)**: Returns immediately with `PROCESSING` status. Use webhooks or polling to get results.
        - **Synchronous**: Set `sync: true` to wait for completion and get final results in the response (5-minute timeout).

        **For asynchronous processing:**
        - You can [configure webhooks](https://docs.extend.ai/2025-04-21/developers/webhooks/configuration) to receive notifications when a processor run is complete or failed.
        - Or you can [poll the get endpoint](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/get-processor-run) for updates on the status of the processor run.

        Parameters
        ----------
        processor_id : ProcessorId

        version : typing.Optional[str]
            An optional version of the processor to use. When not supplied, the most recent published version of the processor will be used. Special values include:
            - `"latest"` for the most recent published version. If there are no published versions, the draft version will be used.
            - `"draft"` for the draft version.
            - Specific version numbers corresponding to versions your team has published, e.g. `"1.0"`, `"2.2"`, etc.

        file : typing.Optional[ProcessorRunFileInput]
            The file to be processed. One of `file` or `rawText` must be provided. Supported file types can be found [here](/product/general/supported-file-types).

        raw_text : typing.Optional[str]
            A raw string to be processed. Can be used in place of file when passing raw text data streams. One of `file` or `rawText` must be provided.

        sync : typing.Optional[bool]
            Whether to run the processor synchronously. When `true`, the request will wait for the processor run to complete and return the final results. When `false` (default), the request returns immediately with a `PROCESSING` status, and you can poll for completion or use webhooks. For production use cases, we recommending leaving sync off and building around an async integration for more resiliency, unless your use case is predictably fast (e.g. sub < 30 seconds) run time or otherwise have integration constraints that require a synchronous API.

            **Timeout**: Synchronous requests have a 5-minute timeout. If the processor run takes longer, it will continue processing asynchronously and you can retrieve the results via the GET endpoint.

        priority : typing.Optional[int]
            An optional value used to determine the relative order of ProcessorRuns when rate limiting is in effect. Lower values will be prioritized before higher values.

        metadata : typing.Optional[JsonObject]
            An optional object that can be passed in to identify the run of the document processor. It will be returned back to you in the response and webhooks.

        config : typing.Optional[ProcessorRunCreateRequestConfig]
            The configuration for the processor run. If this is provided, this config will be used. If not provided, the config for the specific version you provide will be used. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorRunCreateResponse]
            Successfully created processor run
        """
        _response = await self._client_wrapper.httpx_client.request(
            "processor_runs",
            method="POST",
            json={
                "processorId": processor_id,
                "version": version,
                "file": convert_and_respect_annotation_metadata(
                    object_=file, annotation=ProcessorRunFileInput, direction="write"
                ),
                "rawText": raw_text,
                "sync": sync,
                "priority": priority,
                "metadata": metadata,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorRunCreateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunCreateResponse,
                    construct_type(
                        type_=ProcessorRunCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        TooManyRequestsErrorBody,
                        construct_type(
                            type_=TooManyRequestsErrorBody,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProcessorRunGetResponse]:
        """
        Retrieve details about a specific processor run, including its status, outputs, and any edits made during review.

        A common use case for this endpoint is to poll for the status and final output of an async processor run when using the [Run Processor](https://docs.extend.ai/2025-04-21/developers/api-reference/processor-endpoints/run-processor) endpoint. For instance, if you do not want to not configure webhooks to receive the output via completion/failure events.

        Parameters
        ----------
        id : str
            The unique identifier for this processor run.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorRunGetResponse]
            Successfully retrieved processor run
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processor_runs/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunGetResponse,
                    construct_type(
                        type_=ProcessorRunGetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProcessorRunDeleteResponse]:
        """
        Delete a processor run and all associated data from Extend. This operation is permanent and cannot be undone.

        This endpoint can be used if you'd like to manage data retention on your own rather than automated data retention policies. Or make one-off deletions for your downstream customers.

        Parameters
        ----------
        id : str
            The ID of the processor run to delete.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorRunDeleteResponse]
            Successfully deleted processor run
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processor_runs/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunDeleteResponse,
                    construct_type(
                        type_=ProcessorRunDeleteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ExtendError,
                        construct_type(
                            type_=ExtendError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cancel(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProcessorRunCancelResponse]:
        """
        Cancel a running processor run by its ID. This endpoint allows you to stop a processor run that is currently in progress.

        Note: Only processor runs with a status of `"PROCESSING"` can be cancelled. Processor runs that have already completed, failed, or been cancelled cannot be cancelled again.

        Parameters
        ----------
        id : str
            The unique identifier for the processor run to cancel.

            Example: `"dpr_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorRunCancelResponse]
            Successfully cancelled processor run
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processor_runs/{jsonable_encoder(id)}/cancel",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorRunCancelResponse,
                    construct_type(
                        type_=ProcessorRunCancelResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
