# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawProcessorVersionClient, RawProcessorVersionClient
from .types.processor_version_create_request_config import ProcessorVersionCreateRequestConfig
from .types.processor_version_create_request_release_type import ProcessorVersionCreateRequestReleaseType
from .types.processor_version_create_response import ProcessorVersionCreateResponse
from .types.processor_version_get_response import ProcessorVersionGetResponse
from .types.processor_version_list_response import ProcessorVersionListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProcessorVersionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProcessorVersionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProcessorVersionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProcessorVersionClient
        """
        return self._raw_client

    def get(
        self, processor_id: str, processor_version_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessorVersionGetResponse:
        """
        Retrieve a specific version of a processor in Extend

        Parameters
        ----------
        processor_id : str
            The ID of the processor.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        processor_version_id : str
            The ID of the specific processor version to retrieve.

            Example: `"dpv_QYk6jgHA_8CsO8rVWhyNC"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorVersionGetResponse
            Successfully retrieved processor version

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_version.get(processor_id='processor_id_here', processor_version_id='processor_version_id_here', )
        """
        _response = self._raw_client.get(processor_id, processor_version_id, request_options=request_options)
        return _response.data

    def list(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProcessorVersionListResponse:
        """
        This endpoint allows you to fetch all versions of a given processor, including the current `draft` version.

        Versions are typically returned in descending order of creation (newest first), but this should be confirmed in the actual implementation.
        The `draft` version is the latest unpublished version of the processor, which can be published to create a new version. It might not have any changes from the last published version.

        Parameters
        ----------
        id : str
            The ID of the processor to retrieve versions for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorVersionListResponse
            Successfully retrieved processor versions

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_version.list(id='processor_id_here', )
        """
        _response = self._raw_client.list(id, request_options=request_options)
        return _response.data

    def create(
        self,
        id: str,
        *,
        release_type: ProcessorVersionCreateRequestReleaseType,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorVersionCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessorVersionCreateResponse:
        """
        This endpoint allows you to publish a new version of an existing processor. Publishing a new version creates a snapshot of the processor's current configuration and makes it available for use in workflows.

        Publishing a new version does not automatically update existing workflows using this processor. You may need to manually update workflows to use the new version if desired.

        Parameters
        ----------
        id : str
            The ID of the processor to publish a new version for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        release_type : ProcessorVersionCreateRequestReleaseType
            The type of release for this version. The two options are "major" and "minor", which will increment the version number accordingly.

        description : typing.Optional[str]
            A description of the changes in this version. This helps track the evolution of the processor over time.

        config : typing.Optional[ProcessorVersionCreateRequestConfig]
            The configuration for this version of the processor. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorVersionCreateResponse
            Successfully published processor version

        Examples
        --------
        from extend_ai import Extend
        client = Extend(token="YOUR_TOKEN", )
        client.processor_version.create(id='processor_id_here', release_type="major", )
        """
        _response = self._raw_client.create(
            id, release_type=release_type, description=description, config=config, request_options=request_options
        )
        return _response.data


class AsyncProcessorVersionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProcessorVersionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProcessorVersionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProcessorVersionClient
        """
        return self._raw_client

    async def get(
        self, processor_id: str, processor_version_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessorVersionGetResponse:
        """
        Retrieve a specific version of a processor in Extend

        Parameters
        ----------
        processor_id : str
            The ID of the processor.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        processor_version_id : str
            The ID of the specific processor version to retrieve.

            Example: `"dpv_QYk6jgHA_8CsO8rVWhyNC"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorVersionGetResponse
            Successfully retrieved processor version

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_version.get(processor_id='processor_id_here', processor_version_id='processor_version_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(processor_id, processor_version_id, request_options=request_options)
        return _response.data

    async def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProcessorVersionListResponse:
        """
        This endpoint allows you to fetch all versions of a given processor, including the current `draft` version.

        Versions are typically returned in descending order of creation (newest first), but this should be confirmed in the actual implementation.
        The `draft` version is the latest unpublished version of the processor, which can be published to create a new version. It might not have any changes from the last published version.

        Parameters
        ----------
        id : str
            The ID of the processor to retrieve versions for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorVersionListResponse
            Successfully retrieved processor versions

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_version.list(id='processor_id_here', )
        asyncio.run(main())
        """
        _response = await self._raw_client.list(id, request_options=request_options)
        return _response.data

    async def create(
        self,
        id: str,
        *,
        release_type: ProcessorVersionCreateRequestReleaseType,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorVersionCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProcessorVersionCreateResponse:
        """
        This endpoint allows you to publish a new version of an existing processor. Publishing a new version creates a snapshot of the processor's current configuration and makes it available for use in workflows.

        Publishing a new version does not automatically update existing workflows using this processor. You may need to manually update workflows to use the new version if desired.

        Parameters
        ----------
        id : str
            The ID of the processor to publish a new version for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        release_type : ProcessorVersionCreateRequestReleaseType
            The type of release for this version. The two options are "major" and "minor", which will increment the version number accordingly.

        description : typing.Optional[str]
            A description of the changes in this version. This helps track the evolution of the processor over time.

        config : typing.Optional[ProcessorVersionCreateRequestConfig]
            The configuration for this version of the processor. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProcessorVersionCreateResponse
            Successfully published processor version

        Examples
        --------
        from extend_ai import AsyncExtend
        import asyncio
        client = AsyncExtend(token="YOUR_TOKEN", )
        async def main() -> None:
            await client.processor_version.create(id='processor_id_here', release_type="major", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id, release_type=release_type, description=description, config=config, request_options=request_options
        )
        return _response.data
