# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error import Error
from .types.processor_version_create_request_config import ProcessorVersionCreateRequestConfig
from .types.processor_version_create_request_release_type import ProcessorVersionCreateRequestReleaseType
from .types.processor_version_create_response import ProcessorVersionCreateResponse
from .types.processor_version_get_response import ProcessorVersionGetResponse
from .types.processor_version_list_response import ProcessorVersionListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawProcessorVersionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, processor_id: str, processor_version_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProcessorVersionGetResponse]:
        """
        Retrieve a specific version of a processor in Extend

        Parameters
        ----------
        processor_id : str
            The ID of the processor.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        processor_version_id : str
            The ID of the specific processor version to retrieve.

            Example: `"dpv_QYk6jgHA_8CsO8rVWhyNC"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorVersionGetResponse]
            Successfully retrieved processor version
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(processor_id)}/versions/{jsonable_encoder(processor_version_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorVersionGetResponse,
                    construct_type(
                        type_=ProcessorVersionGetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ProcessorVersionListResponse]:
        """
        This endpoint allows you to fetch all versions of a given processor, including the current `draft` version.

        Versions are typically returned in descending order of creation (newest first), but this should be confirmed in the actual implementation.
        The `draft` version is the latest unpublished version of the processor, which can be published to create a new version. It might not have any changes from the last published version.

        Parameters
        ----------
        id : str
            The ID of the processor to retrieve versions for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorVersionListResponse]
            Successfully retrieved processor versions
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(id)}/versions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorVersionListResponse,
                    construct_type(
                        type_=ProcessorVersionListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        id: str,
        *,
        release_type: ProcessorVersionCreateRequestReleaseType,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorVersionCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProcessorVersionCreateResponse]:
        """
        This endpoint allows you to publish a new version of an existing processor. Publishing a new version creates a snapshot of the processor's current configuration and makes it available for use in workflows.

        Publishing a new version does not automatically update existing workflows using this processor. You may need to manually update workflows to use the new version if desired.

        Parameters
        ----------
        id : str
            The ID of the processor to publish a new version for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        release_type : ProcessorVersionCreateRequestReleaseType
            The type of release for this version. The two options are "major" and "minor", which will increment the version number accordingly.

        description : typing.Optional[str]
            A description of the changes in this version. This helps track the evolution of the processor over time.

        config : typing.Optional[ProcessorVersionCreateRequestConfig]
            The configuration for this version of the processor. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessorVersionCreateResponse]
            Successfully published processor version
        """
        _response = self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(id)}/publish",
            method="POST",
            json={
                "releaseType": release_type,
                "description": description,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorVersionCreateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorVersionCreateResponse,
                    construct_type(
                        type_=ProcessorVersionCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawProcessorVersionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, processor_id: str, processor_version_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProcessorVersionGetResponse]:
        """
        Retrieve a specific version of a processor in Extend

        Parameters
        ----------
        processor_id : str
            The ID of the processor.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        processor_version_id : str
            The ID of the specific processor version to retrieve.

            Example: `"dpv_QYk6jgHA_8CsO8rVWhyNC"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorVersionGetResponse]
            Successfully retrieved processor version
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(processor_id)}/versions/{jsonable_encoder(processor_version_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorVersionGetResponse,
                    construct_type(
                        type_=ProcessorVersionGetResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ProcessorVersionListResponse]:
        """
        This endpoint allows you to fetch all versions of a given processor, including the current `draft` version.

        Versions are typically returned in descending order of creation (newest first), but this should be confirmed in the actual implementation.
        The `draft` version is the latest unpublished version of the processor, which can be published to create a new version. It might not have any changes from the last published version.

        Parameters
        ----------
        id : str
            The ID of the processor to retrieve versions for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorVersionListResponse]
            Successfully retrieved processor versions
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(id)}/versions",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorVersionListResponse,
                    construct_type(
                        type_=ProcessorVersionListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        id: str,
        *,
        release_type: ProcessorVersionCreateRequestReleaseType,
        description: typing.Optional[str] = OMIT,
        config: typing.Optional[ProcessorVersionCreateRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProcessorVersionCreateResponse]:
        """
        This endpoint allows you to publish a new version of an existing processor. Publishing a new version creates a snapshot of the processor's current configuration and makes it available for use in workflows.

        Publishing a new version does not automatically update existing workflows using this processor. You may need to manually update workflows to use the new version if desired.

        Parameters
        ----------
        id : str
            The ID of the processor to publish a new version for.

            Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`

        release_type : ProcessorVersionCreateRequestReleaseType
            The type of release for this version. The two options are "major" and "minor", which will increment the version number accordingly.

        description : typing.Optional[str]
            A description of the changes in this version. This helps track the evolution of the processor over time.

        config : typing.Optional[ProcessorVersionCreateRequestConfig]
            The configuration for this version of the processor. The type of configuration must match the processor type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessorVersionCreateResponse]
            Successfully published processor version
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"processors/{jsonable_encoder(id)}/publish",
            method="POST",
            json={
                "releaseType": release_type,
                "description": description,
                "config": convert_and_respect_annotation_metadata(
                    object_=config, annotation=ProcessorVersionCreateRequestConfig, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessorVersionCreateResponse,
                    construct_type(
                        type_=ProcessorVersionCreateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
