# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ArrayStrategy(UncheckedBaseModel):
    type: typing.Literal["large_array_heuristics"] = pydantic.Field(default="large_array_heuristics")
    """
    The strategy type for handling arrays.
    - `large_array_heuristics`: Optimized for documents with very large arrays. Uses specialized heuristics around chunking, tables, and merging to handle large arrays efficiently over large documents.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
