# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class BaseMetrics(UncheckedBaseModel):
    """
    Base metrics common to all processor types
    """

    num_files: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="numFiles")] = pydantic.Field(
        default=None
    )
    """
    The total number of files that were processed.
    """

    num_pages: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="numPages")] = pydantic.Field(
        default=None
    )
    """
    The total number of pages that were processed.
    """

    mean_run_time_ms: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="meanRunTimeMs")] = (
        pydantic.Field(default=None)
    )
    """
    The mean runtime in milliseconds per document.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
