# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .batch_processor_run_metrics import BatchProcessorRunMetrics
from .batch_processor_run_options import BatchProcessorRunOptions
from .batch_processor_run_source import BatchProcessorRunSource
from .batch_processor_run_status import BatchProcessorRunStatus


class BatchProcessorRun(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of response. In this case, it will always be `"batch_processor_run"`.
    """

    id: str = pydantic.Field()
    """
    The unique identifier for this batch processor run.
    
    Example: `"batch_processor_run_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    The ID of the processor used for this run.
    
    Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    processor_version_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorVersionId")] = pydantic.Field()
    """
    The ID of the specific processor version used.
    
    Example: `"dpv_xK9mLPqRtN3vS8wF5hB2cQ"`
    """

    processor_name: typing_extensions.Annotated[str, FieldMetadata(alias="processorName")] = pydantic.Field()
    """
    The name of the processor.
    
    Example: `"Invoice Processor"`
    """

    metrics: BatchProcessorRunMetrics
    status: BatchProcessorRunStatus = pydantic.Field()
    """
    The current status of the batch processor run:
    * `"PENDING"` - The batch processor run is waiting to start
    * `"PROCESSING"` - The batch processor run is in progress
    * `"PROCESSED"` - The batch processor run completed successfully
    * `"FAILED"` - The batch processor run encountered an error
    """

    source: BatchProcessorRunSource = pydantic.Field()
    """
    The source of the batch processor run:
    * `"EVAL_SET"` - The batch processor run was made from an evaluation set. The `sourceId` will be the ID of the evaluation set (e.g., `"ev_1234"`)
    * `"PLAYGROUND"` - The batch processor run was made from the playground. The `sourceId` will not be set
    * `"STUDIO"` - The batch processor run was made for a processor in Studio. The `sourceId` will be the ID of the processor (e.g., `"dp_1234"`)
    """

    source_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="sourceId")] = pydantic.Field(
        default=None
    )
    """
    The ID of the source of the batch processor run. See the `source` field for more details.
    Example: `"ev_1234"` for EVAL_SET source, `"dp_1234"` for STUDIO source
    """

    run_count: typing_extensions.Annotated[int, FieldMetadata(alias="runCount")] = pydantic.Field()
    """
    The number of runs that were made.
    """

    options: BatchProcessorRunOptions = pydantic.Field()
    """
    The options for the batch processor run.
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which the batch processor run was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which the batch processor run was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
