# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .block_bounding_box import BlockBoundingBox
from .block_details import BlockDetails
from .block_metadata import BlockMetadata
from .block_polygon_item import BlockPolygonItem
from .block_type import BlockType


class Block(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of object. In this case, it will always be `"block"`.
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the block, deterministically generated as a hash of the block content.
    """

    type: BlockType = pydantic.Field()
    """
    The type of block:
    * `"text"` - Regular text content
    * `"heading"` - Section or document headings 
    * `"section_heading"` - Subsection headings
    * `"table"` - Tabular data with rows and columns
    * `"table_head"` - Table header cells
    * `"table_cell"` - Table body cells
    * `"figure"` - Images, charts, diagrams, or logos
    """

    content: str = pydantic.Field()
    """
    The textual content of the block formatted based on the target format.
    """

    details: BlockDetails = pydantic.Field()
    """
    Additional details specific to the block type. The schema depends on the block type.
    """

    metadata: BlockMetadata = pydantic.Field()
    """
    Metadata about the block.
    """

    polygon: typing.List[BlockPolygonItem] = pydantic.Field()
    """
    An array of points defining the polygon that bounds the block.
    """

    bounding_box: typing_extensions.Annotated[BlockBoundingBox, FieldMetadata(alias="boundingBox")] = pydantic.Field()
    """
    A simplified bounding box for the block.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
