# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class BlockMetadataPage(UncheckedBaseModel):
    """
    Information about the page this block appears on.
    """

    number: int = pydantic.Field()
    """
    The page number where this block appears.
    """

    width: typing.Optional[float] = pydantic.Field(default=None)
    """
    The width of the page in points.
    """

    height: typing.Optional[float] = pydantic.Field(default=None)
    """
    The height of the page in points.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
