# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .block import Block
from .chunk_metadata import ChunkMetadata
from .chunk_type import ChunkType


class Chunk(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of object. In this case, it will always be `"chunk"`.
    """

    type: ChunkType = pydantic.Field()
    """
    The type of chunk.
    """

    content: str = pydantic.Field()
    """
    The parsed content of the chunk.
    """

    metadata: ChunkMetadata = pydantic.Field()
    """
    Metadata about the chunk.
    """

    blocks: typing.List[Block] = pydantic.Field()
    """
    An array of block objects that make up the chunk. A Block represents a distinct content element within a document, such as a paragraph of text, a heading, a table, or a figure. Blocks are the fundamental units that make up chunks in parsed documents.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
