# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class Classification(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    Unique identifier for the classification. We recommend lowercase, underscore-separated format.
    """

    type: str = pydantic.Field()
    """
    Type identifier for the classification.
    """

    description: str = pydantic.Field()
    """
    A detailed description of the classification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
