# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .classification_advanced_options_context import ClassificationAdvancedOptionsContext
from .page_ranges import PageRanges


class ClassificationAdvancedOptions(UncheckedBaseModel):
    context: typing.Optional[ClassificationAdvancedOptionsContext] = pydantic.Field(default=None)
    """
    The context to use for classification.
    """

    advanced_multimodal_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="advancedMultimodalEnabled")
    ] = pydantic.Field(default=None)
    """
    Enable advanced multimodal processing for better handling of visual elements during classification.
    """

    fixed_page_limit: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="fixedPageLimit")] = (
        pydantic.Field(default=None)
    )
    """
    Limit processing to a specific number of pages from the beginning of the document. See [Page Ranges](/product/page-ranges).
    """

    page_ranges: typing_extensions.Annotated[typing.Optional[PageRanges], FieldMetadata(alias="pageRanges")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
