# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .classification import Classification
from .classification_advanced_options import ClassificationAdvancedOptions
from .classification_config_base_processor import ClassificationConfigBaseProcessor
from .parse_config import ParseConfig


class ClassificationConfig(UncheckedBaseModel):
    base_processor: typing_extensions.Annotated[
        typing.Optional[ClassificationConfigBaseProcessor], FieldMetadata(alias="baseProcessor")
    ] = pydantic.Field(default=None)
    """
    The base processor to use. For classifiers, this must be either `"classification_performance"` or `"classification_light"`. See [Classification Changelog](/changelog/classification/classification-performance) for more details.
    """

    base_version: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="baseVersion")] = (
        pydantic.Field(default=None)
    )
    """
    The version of the `"classification_performance"` or `"classification_light"` processor to use. If this is provided, the `baseProcessor` must also be provided. See [Classification Changelog](/changelog/classification/classification-performance) for more details.
    """

    classifications: typing.List[Classification] = pydantic.Field()
    """
    Array of possible classifications for the document.
    """

    classification_rules: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="classificationRules")
    ] = pydantic.Field(default=None)
    """
    Custom rules to guide the classification process in natural language.
    """

    advanced_options: typing_extensions.Annotated[
        typing.Optional[ClassificationAdvancedOptions], FieldMetadata(alias="advancedOptions")
    ] = pydantic.Field(default=None)
    """
    Advanced configuration options.
    """

    parser: typing.Optional[ParseConfig] = pydantic.Field(default=None)
    """
    Configuration options for the parsing process.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
