# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .insight import Insight


class ClassifierOutput(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The unique identifier for this classification
    """

    type: str = pydantic.Field()
    """
    The type of classification
    """

    confidence: float = pydantic.Field()
    """
    A value between 0 and 1 indicating the model's confidence in the classification, where 1 represents maximum confidence
    """

    insights: typing.List[Insight] = pydantic.Field()
    """
    Additional insights about the classification decision
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
