# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .base_metrics import BaseMetrics


class ClassifyMetrics(BaseMetrics):
    """
    Metrics specific to classification processors
    """

    type: typing.Optional[typing.Literal["CLASSIFY"]] = pydantic.Field(default=None)
    """
    The type of metrics. Will always be `"CLASSIFY"` for classification processors.
    """

    accuracy_perc: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="accuracyPerc")] = (
        pydantic.Field(default=None)
    )
    """
    The overall accuracy percentage.
    """

    mean_confidence: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="meanConfidence")] = (
        pydantic.Field(default=None)
    )
    """
    The mean confidence score.
    """

    distribution: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Record mapping classification values to their counts.
    """

    accuracy_perc_by_classification: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]],
        FieldMetadata(alias="accuracyPercByClassification"),
    ] = pydantic.Field(default=None)
    """
    Mapping from classification to accuracy percentage as calculated from the confusion matrix.
    """

    confusion_matrix: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="confusionMatrix")
    ] = pydantic.Field(default=None)
    """
    Mapping from actual class to predicted class to count. Only present when accuracy percentage is present.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
