# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class DocumentProcessorRunCredits(UncheckedBaseModel):
    """
    These are usage credits for document processing (extraction, classification, or splitting). File parsing credits are tracked separately and can be retrieved from the [Get File](/developers/api-reference/file-endpoints/get-file) endpoint.

    This field will not be returned for processor runs created before October 7, 2025, or for customers on legacy billing systems.

    For more details on how credits work, see our [Credits Guide](/product/general/how-credits-work).
    """

    credits: float = pydantic.Field()
    """
    The number of credits consumed specifically for document processing in this processor run. This does not include file parsing credits.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
