# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class EnumOption(UncheckedBaseModel):
    value: str = pydantic.Field()
    """
    The enum value (e.g. "ANNUAL", "MONTHLY", etc.)
    """

    description: str = pydantic.Field()
    """
    The description of the enum value
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
