# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class EvaluationSet(UncheckedBaseModel):
    """
    The EvaluationSet object represents an evaluation set in Extend. Evaluation sets are collections of files and expected outputs that are used to evaluate the performance of a given processor in Extend.
    """

    object: str = pydantic.Field()
    """
    The type of response. In this case, it will always be `"evaluation_set"`.
    """

    id: str = pydantic.Field()
    """
    The ID of the evaluation set.
    
    Example: `"ev_2LcgeY_mp2T5yPaEuq5Lw"`
    """

    name: str = pydantic.Field()
    """
    The name of the evaluation set.
    
    Example: `"Invoice Processing Test Set"`
    """

    description: str = pydantic.Field()
    """
    A description of the evaluation set.
    
    Example: `"Q4 2023 vendor invoices for accuracy testing"`
    """

    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    The ID of the processor associated with this evaluation set.
    
    Example: `"dp_Xj8mK2pL9nR4vT7qY5wZ"`
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which the evaluation set was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which the evaluation set was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
