# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from .base_metrics import BaseMetrics
from .extract_metrics_field_metrics import ExtractMetricsFieldMetrics


class ExtractMetrics(BaseMetrics):
    """
    Metrics specific to extraction processors
    """

    type: typing.Optional[typing.Literal["EXTRACT"]] = pydantic.Field(default=None)
    """
    The type of metrics. Will always be `"EXTRACT"` for extraction processors.
    """

    field_metrics: typing_extensions.Annotated[
        typing.Optional[ExtractMetricsFieldMetrics], FieldMetadata(alias="fieldMetrics")
    ] = pydantic.Field(default=None)
    """
    Record mapping field names to their respective metrics.
    """

    array_cardinality_metrics: typing_extensions.Annotated[
        typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]], FieldMetadata(alias="arrayCardinalityMetrics")
    ] = pydantic.Field(default=None)
    """
    Maps the root array field name to a number indicating how many times the array field has the correct number of rows extracted.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
