# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .array_strategy import ArrayStrategy
from .excel_sheet_range import ExcelSheetRange
from .extract_chunking_options import ExtractChunkingOptions
from .extraction_advanced_options_excel_sheet_selection_strategy import (
    ExtractionAdvancedOptionsExcelSheetSelectionStrategy,
)
from .page_ranges import PageRanges


class ExtractionAdvancedOptions(UncheckedBaseModel):
    document_kind: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="documentKind")] = (
        pydantic.Field(default=None)
    )
    """
    DEPRECATED - use extractionRules for all system prompts.
    """

    key_definitions: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="keyDefinitions")] = (
        pydantic.Field(default=None)
    )
    """
    DEPRECATED - use extractionRules for all system prompts.
    """

    model_reasoning_insights_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="modelReasoningInsightsEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether to enable model reasoning insights.
    """

    advanced_multimodal_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="advancedMultimodalEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether to enable advanced multimodal features.
    """

    citations_enabled: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="citationsEnabled")] = (
        pydantic.Field(default=None)
    )
    """
    Whether to enable citations in the output.
    """

    advanced_figure_parsing_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="advancedFigureParsingEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether to enable advanced figure parsing.
    """

    array_strategy: typing_extensions.Annotated[
        typing.Optional[ArrayStrategy], FieldMetadata(alias="arrayStrategy")
    ] = pydantic.Field(default=None)
    """
    Strategy for handling large arrays in documents.
    """

    chunking_options: typing_extensions.Annotated[
        typing.Optional[ExtractChunkingOptions], FieldMetadata(alias="chunkingOptions")
    ] = None
    excel_sheet_ranges: typing_extensions.Annotated[
        typing.Optional[typing.List[ExcelSheetRange]], FieldMetadata(alias="excelSheetRanges")
    ] = pydantic.Field(default=None)
    """
    Ranges of sheet indices to extract from Excel documents.
    """

    excel_sheet_selection_strategy: typing_extensions.Annotated[
        typing.Optional[ExtractionAdvancedOptionsExcelSheetSelectionStrategy],
        FieldMetadata(alias="excelSheetSelectionStrategy"),
    ] = pydantic.Field(default=None)
    """
    Strategy for selecting sheets from Excel documents.
    """

    fixed_page_limit: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="fixedPageLimit")] = (
        pydantic.Field(default=None)
    )
    """
    DEPRECATED - See [Page Ranges](/product/page-ranges).
    """

    page_ranges: typing_extensions.Annotated[typing.Optional[PageRanges], FieldMetadata(alias="pageRanges")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
