# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .extraction_advanced_options import ExtractionAdvancedOptions
from .extraction_config_base_processor import ExtractionConfigBaseProcessor
from .json_object import JsonObject
from .parse_config import ParseConfig


class ExtractionConfig(UncheckedBaseModel):
    base_processor: typing_extensions.Annotated[
        typing.Optional[ExtractionConfigBaseProcessor], FieldMetadata(alias="baseProcessor")
    ] = pydantic.Field(default=None)
    """
    The base processor to use. For extractors, this must be either `"extraction_performance"` or `"extraction_light"`. See [Extraction Changelog](/changelog/extraction/extraction-performance) for more details.
    """

    base_version: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="baseVersion")] = (
        pydantic.Field(default=None)
    )
    """
    The version of the `"extraction_performance"` or `"extraction_light"` processor to use. If this is provided, the `baseProcessor` must also be provided. See [Extraction Changelog](/changelog/extraction/extraction-performance) for more details.
    """

    extraction_rules: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="extractionRules")] = (
        pydantic.Field(default=None)
    )
    """
    Custom rules to guide the extraction process in natural language.
    """

    schema_: typing_extensions.Annotated[typing.Optional[JsonObject], FieldMetadata(alias="schema")] = pydantic.Field(
        default=None
    )
    """
    JSON Schema definition of the data to extract. Either `fields` or `schema` must be provided.
    
    See the [JSON Schema guide](/product/extraction/schema/json-schema) for details and examples of schema configuration.
    """

    fields: typing.Optional[typing.List["ExtractionField"]] = pydantic.Field(default=None)
    """
    Array of fields to extract from the document. Either `fields` or `schema` must be provided.
    
    We recommend using `schema` for new implementations.
    """

    advanced_options: typing_extensions.Annotated[
        typing.Optional[ExtractionAdvancedOptions], FieldMetadata(alias="advancedOptions")
    ] = pydantic.Field(default=None)
    """
    Advanced configuration options.
    """

    parser: typing.Optional[ParseConfig] = pydantic.Field(default=None)
    """
    Configuration options for the parsing process.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(ExtractionConfig)
