# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .enum import Enum
from .extraction_field_type import ExtractionFieldType


class ExtractionField(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    Unique identifier for the field.
    """

    name: str = pydantic.Field()
    """
    Human-readable name for the field.
    """

    type: ExtractionFieldType = pydantic.Field()
    """
    The type of the field.
    """

    description: str = pydantic.Field()
    """
    Detailed description of the field, including expected content and format.
    """

    schema_: typing_extensions.Annotated[
        typing.Optional[typing.List["ExtractionField"]], FieldMetadata(alias="schema")
    ] = pydantic.Field(default=None)
    """
    Required when type is "array" or "object". Contains nested field definitions.
    """

    enum: typing.Optional[typing.List[Enum]] = pydantic.Field(default=None)
    """
    Required when type is "enum". List of allowed values.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(ExtractionField)
