# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .enum_option import EnumOption
from .extraction_field_result_reference import ExtractionFieldResultReference
from .extraction_field_result_type import ExtractionFieldResultType
from .insight import Insight


class ExtractionFieldResult(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The unique identifier for this field
    """

    type: ExtractionFieldResultType = pydantic.Field()
    """
    The type of the extracted field
    """

    value: typing.Optional[typing.Any] = None
    confidence: typing.Optional[float] = pydantic.Field(default=None)
    """
    A value between 0 and 1 indicating confidence in the extraction
    """

    schema_: typing_extensions.Annotated[
        typing.Optional[typing.List["ExtractionField"]], FieldMetadata(alias="schema")
    ] = pydantic.Field(default=None)
    """
    The field schema of nested fields
    """

    insights: typing.Optional[typing.List[Insight]] = pydantic.Field(default=None)
    """
    Reasoning and other insights from the model
    """

    references: typing.List[ExtractionFieldResultReference] = pydantic.Field()
    """
    References for the extracted field
    """

    enum: typing.Optional[typing.List[EnumOption]] = pydantic.Field(default=None)
    """
    The enum options for enum fields, only set when type=enum
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(ExtractionFieldResult)
