# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .extraction_field_result_reference_bounding_boxes_item import ExtractionFieldResultReferenceBoundingBoxesItem


class ExtractionFieldResultReference(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    The unique identifier for this field
    """

    field_name: typing_extensions.Annotated[str, FieldMetadata(alias="fieldName")] = pydantic.Field()
    """
    The name of the extracted field
    """

    page: float = pydantic.Field()
    """
    The page number that this bounding box is from
    """

    bounding_boxes: typing_extensions.Annotated[
        typing.List[ExtractionFieldResultReferenceBoundingBoxesItem], FieldMetadata(alias="boundingBoxes")
    ] = pydantic.Field()
    """
    The bounding boxes of the field
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
