# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class ExtractionOutputEdits(UncheckedBaseModel):
    """
    A record of edits made to the processor output.
    """

    original_value: typing_extensions.Annotated[
        typing.Optional[typing.Optional[typing.Any]], FieldMetadata(alias="originalValue")
    ] = None
    edited_value: typing_extensions.Annotated[
        typing.Optional[typing.Optional[typing.Any]], FieldMetadata(alias="editedValue")
    ] = None
    notes: typing.Optional[str] = pydantic.Field(default=None)
    """
    Any notes added during editing.
    """

    page: typing.Optional[float] = pydantic.Field(default=None)
    """
    The page number where the edit was made.
    """

    field_type: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="fieldType")] = pydantic.Field(
        default=None
    )
    """
    The type of the edited field.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
