# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .figure_details_figure_type import FigureDetailsFigureType


class FigureDetails(UncheckedBaseModel):
    """
    Details for figure blocks
    """

    type: typing.Literal["figure_details"] = pydantic.Field(default="figure_details")
    """
    Indicates this is a figure details object
    """

    image_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="imageUrl")] = pydantic.Field(
        default=None
    )
    """
    URL to the clipped/segmented figure image. Only set if the option `figureImageClippingEnabled` in the input is `true`, which it is by default.
    """

    figure_type: typing_extensions.Annotated[
        typing.Optional[FigureDetailsFigureType], FieldMetadata(alias="figureType")
    ] = pydantic.Field(default=None)
    """
    The refined type of figure - only set when figure classification and summarization is enabled. Possible values:
    
    * `image`: A photographic image
    * `chart`: A data chart or graph
    * `diagram`: A schematic or diagram
    * `logo`: A company or brand logo
    * `other`: Any other type of figure
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
