# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .file_contents import FileContents
from .file_credits import FileCredits
from .file_metadata import FileMetadata
from .file_type import FileType


class File(UncheckedBaseModel):
    object: str = pydantic.Field()
    """
    The type of response. In this case, it will always be "file".
    """

    id: str = pydantic.Field()
    """
    Extend's internal ID for the file. It will always start with `"file_"`.
    
    Example: `"file_xK9mLPqRtN3vS8wF5hB2cQ"`
    """

    name: str = pydantic.Field()
    """
    The name of the file
    
    Example: `"Invoices.pdf"`
    """

    type: typing.Optional[FileType] = pydantic.Field(default=None)
    """
    The type of the file
    """

    presigned_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="presignedUrl")] = (
        pydantic.Field(default=None)
    )
    """
    A presigned URL to download the file. Expires after 15 minutes.
    """

    parent_file_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="parentFileId")] = (
        pydantic.Field(default=None)
    )
    """
    The ID of the parent file. Only included if this file is a derivative of another file, for instance if it was created via a Splitter in a workflow.
    """

    contents: typing.Optional[FileContents] = None
    metadata: FileMetadata
    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    The time (in UTC) at which the file was created. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T15:30:00Z"`
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    The time (in UTC) at which the file was last updated. Will follow the RFC 3339 format.
    
    Example: `"2024-03-21T16:45:00Z"`
    """

    usage: typing.Optional[FileCredits] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
