# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .file_contents_pages_item import FileContentsPagesItem
from .file_contents_sheets_item import FileContentsSheetsItem


class FileContents(UncheckedBaseModel):
    raw_text: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="rawText")] = pydantic.Field(
        default=None
    )
    """
    The raw text content of the file. This is included for all file types if the `rawText` query parameter is set to true in the endpoint request.
    """

    markdown: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cleaned and structured markdown content of the entire file. Available for PDF and IMG file types. Only included if the `markdown` query parameter is set to true in the endpoint request.
    """

    pages: typing.Optional[typing.List[FileContentsPagesItem]] = None
    sheets: typing.Optional[typing.List[FileContentsSheetsItem]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
