# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class FileContentsPagesItem(UncheckedBaseModel):
    page_number: typing_extensions.Annotated[int, FieldMetadata(alias="pageNumber")] = pydantic.Field()
    """
    The page number of this page in the document.
    """

    page_height: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="pageHeight")] = None
    page_width: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="pageWidth")] = None
    raw_text: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="rawText")] = pydantic.Field(
        default=None
    )
    """
    The raw text content extracted from this page.
    """

    markdown: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cleaned and structured markdown content of this page.
    """

    html: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cleaned and structured html content of the page. Available for DOCX file types (that were not auto-converted to PDFs). Only included if the `html` query parameter is set to true in the endpoint request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
