# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .file_metadata_parent_split import FileMetadataParentSplit


class FileMetadata(UncheckedBaseModel):
    page_count: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="pageCount")] = pydantic.Field(
        default=None
    )
    """
    The number of pages in the file. This is only set for PDF/DOCX files.
    """

    parent_split: typing_extensions.Annotated[
        typing.Optional[FileMetadataParentSplit], FieldMetadata(alias="parentSplit")
    ] = pydantic.Field(default=None)
    """
    The split metadata details. Only included if this file is a derivative of another file, for instance if it was created via a Splitter in a workflow.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
