# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel


class FileMetadataParentSplit(UncheckedBaseModel):
    """
    The split metadata details. Only included if this file is a derivative of another file, for instance if it was created via a Splitter in a workflow.
    """

    id: str = pydantic.Field()
    """
    The ID of the split.
    """

    type: str = pydantic.Field()
    """
    The type of the split.
    """

    identifier: str = pydantic.Field()
    """
    The identifier of the split.
    """

    start_page: typing_extensions.Annotated[int, FieldMetadata(alias="startPage")] = pydantic.Field()
    """
    The start page of the split.
    """

    end_page: typing_extensions.Annotated[int, FieldMetadata(alias="endPage")] = pydantic.Field()
    """
    The end page of the split.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
