# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .json_object import JsonObject
from .json_output_metadata_value import JsonOutputMetadataValue


class JsonOutput(UncheckedBaseModel):
    value: JsonObject = pydantic.Field()
    """
    The extracted values conforming to the schema defined in the processor config
    """

    metadata: typing.Dict[str, JsonOutputMetadataValue] = pydantic.Field()
    """
    Metadata about the extracted fields
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
