# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .optimizer_batch_processor_run_result_processor_config import OptimizerBatchProcessorRunResultProcessorConfig
from .optimizer_run_metrics import OptimizerRunMetrics


class OptimizerBatchProcessorRunResult(UncheckedBaseModel):
    batch_processor_run_id: typing_extensions.Annotated[str, FieldMetadata(alias="batchProcessorRunId")] = (
        pydantic.Field()
    )
    """
    Unique identifier for the batch processor run
    """

    is_baseline: typing_extensions.Annotated[bool, FieldMetadata(alias="isBaseline")] = pydantic.Field()
    """
    Whether this is the baseline (original) configuration
    """

    processor_config: typing_extensions.Annotated[
        OptimizerBatchProcessorRunResultProcessorConfig, FieldMetadata(alias="processorConfig")
    ] = pydantic.Field()
    """
    Processor configuration used for this run
    """

    metrics: OptimizerRunMetrics

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(OptimizerBatchProcessorRunResult)
