# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .classification import Classification
from .classification_advanced_options import ClassificationAdvancedOptions
from .classification_config_base_processor import ClassificationConfigBaseProcessor
from .extraction_advanced_options import ExtractionAdvancedOptions
from .extraction_config_base_processor import ExtractionConfigBaseProcessor
from .json_object import JsonObject
from .parse_config import ParseConfig


class OptimizerBatchProcessorRunResultProcessorConfig_Extract(UncheckedBaseModel):
    """
    Processor configuration used for this run
    """

    type: typing.Literal["EXTRACT"] = "EXTRACT"
    base_processor: typing_extensions.Annotated[
        typing.Optional[ExtractionConfigBaseProcessor], FieldMetadata(alias="baseProcessor")
    ] = None
    base_version: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="baseVersion")] = None
    extraction_rules: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="extractionRules")] = None
    schema_: typing_extensions.Annotated[typing.Optional[JsonObject], FieldMetadata(alias="schema")] = None
    fields: typing.Optional[typing.List["ExtractionField"]] = None
    advanced_options: typing_extensions.Annotated[
        typing.Optional[ExtractionAdvancedOptions], FieldMetadata(alias="advancedOptions")
    ] = None
    parser: typing.Optional[ParseConfig] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001


class OptimizerBatchProcessorRunResultProcessorConfig_Classify(UncheckedBaseModel):
    """
    Processor configuration used for this run
    """

    type: typing.Literal["CLASSIFY"] = "CLASSIFY"
    base_processor: typing_extensions.Annotated[
        typing.Optional[ClassificationConfigBaseProcessor], FieldMetadata(alias="baseProcessor")
    ] = None
    base_version: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="baseVersion")] = None
    classifications: typing.List[Classification]
    classification_rules: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="classificationRules")
    ] = None
    advanced_options: typing_extensions.Annotated[
        typing.Optional[ClassificationAdvancedOptions], FieldMetadata(alias="advancedOptions")
    ] = None
    parser: typing.Optional[ParseConfig] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


OptimizerBatchProcessorRunResultProcessorConfig = typing_extensions.Annotated[
    typing.Union[
        OptimizerBatchProcessorRunResultProcessorConfig_Extract,
        OptimizerBatchProcessorRunResultProcessorConfig_Classify,
    ],
    UnionMetadata(discriminant="type"),
]
update_forward_refs(OptimizerBatchProcessorRunResultProcessorConfig_Extract)
