# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, update_forward_refs
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .optimizer_batch_processor_run_result import OptimizerBatchProcessorRunResult
from .optimizer_run_agent_type import OptimizerRunAgentType
from .optimizer_run_status import OptimizerRunStatus


class OptimizerRun(UncheckedBaseModel):
    agent_run_id: typing_extensions.Annotated[str, FieldMetadata(alias="agentRunId")] = pydantic.Field()
    """
    Unique identifier for the optimizer run
    """

    processor_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorId")] = pydantic.Field()
    """
    ID of the processor being optimized
    """

    processor_version_id: typing_extensions.Annotated[str, FieldMetadata(alias="processorVersionId")] = pydantic.Field()
    """
    ID of the processor version being optimized
    """

    eval_set_id: typing_extensions.Annotated[str, FieldMetadata(alias="evalSetId")] = pydantic.Field()
    """
    ID of the evaluation set used
    """

    agent_type: typing_extensions.Annotated[OptimizerRunAgentType, FieldMetadata(alias="agentType")] = pydantic.Field()
    """
    Type of optimizer agent that ran
    """

    status: OptimizerRunStatus = pydantic.Field()
    """
    Current status of the optimizer run
    """

    created_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    ISO 8601 timestamp of when the run was created
    """

    updated_at: typing_extensions.Annotated[dt.datetime, FieldMetadata(alias="updatedAt")] = pydantic.Field()
    """
    ISO 8601 timestamp of when the run was last updated
    """

    batch_processor_runs: typing_extensions.Annotated[
        typing.Optional[typing.List[OptimizerBatchProcessorRunResult]], FieldMetadata(alias="batchProcessorRuns")
    ] = pydantic.Field(default=None)
    """
    Array of batch processor run results. Each run represents one iteration of the optimization process.
    The first result (with `isBaseline: true`) is the baseline configuration.
    Subsequent results are optimization attempts, sorted chronologically.
    Only present when status is `PROCESSED`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .extraction_field import ExtractionField  # noqa: E402, F401, I001

update_forward_refs(OptimizerRun)
