# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .citation import Citation
from .insight import Insight


class OutputMetadataValue(UncheckedBaseModel):
    ocr_confidence: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="ocrConfidence")] = (
        pydantic.Field(default=None)
    )
    """
    Confidence score from OCR processing, if applicable
    """

    logprobs_confidence: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="logprobsConfidence")
    ] = pydantic.Field(default=None)
    """
    Confidence score based on model logprobs
    """

    citations: typing.Optional[typing.List[Citation]] = None
    insights: typing.Optional[typing.List[Insight]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
